/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.Java8MigrationUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8MapApiInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8MapApiInspection.class);
    public static final String SHORT_NAME = "Java8MapApi";
    private static final CallMatcher KEY_VALUE_GET_METHODS = CallMatcher.instanceCall("java.util.Map.Entry", "getKey", "getValue").parameterCount(0);
    public boolean mySuggestMapGetOrDefault = true;
    public boolean mySuggestMapComputeIfAbsent = true;
    public boolean mySuggestMapPutIfAbsent = true;
    public boolean mySuggestMapMerge = true;
    public boolean mySuggestMapReplaceAll = true;
    public boolean myTreatGetNullAsContainsKey = false;
    public boolean mySideEffects = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.suggest.conversion.to.map.computeifabsent", (Object[])new Object[0]), "mySuggestMapComputeIfAbsent");
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.suggest.conversion.to.map.getordefault", (Object[])new Object[0]), "mySuggestMapGetOrDefault");
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.suggest.conversion.to.map.putifabsent", (Object[])new Object[0]), "mySuggestMapPutIfAbsent");
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.suggest.conversion.to.map.merge", (Object[])new Object[0]), "mySuggestMapMerge");
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.suggest.conversion.to.map.replaceall", (Object[])new Object[0]), "mySuggestMapReplaceAll");
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.treat.get.k.null.the.same.as.containskey.k.may.change.semantics", (Object[])new Object[0]), "myTreatGetNullAsContainsKey");
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.suggest.replacement.even.if.lambda.may.have.side.effects", (Object[])new Object[0]), "mySideEffects");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!JavaFeature.ADVANCED_COLLECTIONS_API.isFeatureSupported(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                Java8MigrationUtils.MapCheckCondition condition2 = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)expression2, Java8MapApiInspection.this.myTreatGetNullAsContainsKey);
                if (condition2 == null || condition2.hasVariable()) {
                    return;
                }
                PsiExpression existsBranch = condition2.getExistsBranch(expression2.getThenExpression(), expression2.getElseExpression());
                PsiExpression noneBranch = condition2.getNoneBranch(expression2.getThenExpression(), expression2.getElseExpression());
                this.processGetPut(condition2, (PsiElement)existsBranch, (PsiElement)existsBranch, (PsiElement)noneBranch);
            }

            public void visitIfStatement(PsiIfStatement statement) {
                Java8MigrationUtils.MapCheckCondition condition2 = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)statement, Java8MapApiInspection.this.myTreatGetNullAsContainsKey);
                if (condition2 == null) {
                    return;
                }
                PsiStatement existsBranch = ControlFlowUtils.stripBraces(condition2.getExistsBranch(statement.getThenBranch(), statement.getElseBranch()));
                PsiStatement noneBranch = ControlFlowUtils.stripBraces(condition2.getNoneBranch(statement.getThenBranch(), statement.getElseBranch()));
                if (existsBranch == null) {
                    this.processSingleBranch(condition2, noneBranch);
                } else {
                    if (Java8MapApiInspection.this.mySuggestMapMerge && condition2.isGetNull()) {
                        this.processMerge(condition2, existsBranch, noneBranch);
                    }
                    if (condition2.hasVariable()) {
                        return;
                    }
                    EquivalenceChecker.Match match = EquivalenceChecker.getCanonicalPsiEquivalence().statementsMatch(noneBranch, existsBranch);
                    this.processGetPut(condition2, (PsiElement)existsBranch, match.getRightDiff(), match.getLeftDiff());
                }
            }

            public void visitForeachStatement(PsiForeachStatement statement) {
                if (!Java8MapApiInspection.this.mySuggestMapReplaceAll) {
                    return;
                }
                Java8MigrationUtils.MapLoopCondition condition2 = Java8MigrationUtils.MapLoopCondition.create(statement);
                if (condition2 == null) {
                    return;
                }
                PsiMethodCallExpression putCall = condition2.extractPut(statement);
                if (putCall == null) {
                    return;
                }
                PsiExpression[] args = putCall.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return;
                }
                PsiExpression key2 = args[0];
                if (!condition2.isKeyAccess(key2)) {
                    return;
                }
                PsiExpression value2 = args[1];
                if (condition2.isEntrySet() && this.isUsedAsReference((PsiElement)value2, condition2)) {
                    return;
                }
                if (this.hasMapUsages(condition2, value2)) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)value2, variable -> condition2.getMap().equals(variable))) {
                    return;
                }
                ReplaceWithSingleMapOperation fix = ReplaceWithSingleMapOperation.create("replaceAll", putCall, value2);
                holder.registerProblem(statement.getFirstChild(), QuickFixBundle.message("java.8.map.api.inspection.description", fix.myMethodName), new LocalQuickFix[]{fix});
            }

            private boolean hasMapUsages(@NotNull Java8MigrationUtils.MapLoopCondition condition2, @Nullable PsiExpression value2) {
                return !VariableAccessUtils.getVariableReferences(condition2.getMap(), (PsiElement)value2).stream().map(ExpressionUtils::getCallForQualifier).allMatch(call -> condition2.isValueAccess((PsiExpression)call));
            }

            private boolean isUsedAsReference(@NotNull PsiElement value2, @NotNull Java8MigrationUtils.MapLoopCondition condition2) {
                return !VariableAccessUtils.getVariableReferences((PsiVariable)condition2.getIterParam(), value2).stream().map(ExpressionUtils::getCallForQualifier).allMatch(KEY_VALUE_GET_METHODS);
            }

            private void processMerge(Java8MigrationUtils.MapCheckCondition condition2, PsiStatement existsBranch, PsiStatement noneBranch) {
                if (noneBranch instanceof PsiExpressionStatement && existsBranch instanceof PsiExpressionStatement) {
                    PsiElement[] mapRefs;
                    PsiExpression absentValue = Java8MigrationUtils.extractPutValue(condition2, noneBranch);
                    if (absentValue == null) {
                        return;
                    }
                    PsiExpression presentValue = Java8MigrationUtils.extractPutValue(condition2, existsBranch);
                    if (presentValue == null || !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)presentValue)) {
                        return;
                    }
                    if (!PsiTreeUtil.processElements((PsiElement)absentValue, e -> !condition2.isMap(e))) {
                        return;
                    }
                    boolean hasVariable = condition2.hasVariable();
                    if (hasVariable) {
                        if (PsiTreeUtil.collectElements((PsiElement)presentValue, condition2::isValueReference).length == 0) {
                            return;
                        }
                    }
                    if (hasVariable ^ (mapRefs = PsiTreeUtil.collectElements((PsiElement)presentValue, condition2::isMap)).length == 0) {
                        return;
                    }
                    for (PsiElement mapRef : mapRefs) {
                        PsiElement parent = mapRef.getParent();
                        if (parent instanceof PsiReferenceExpression && condition2.extractGetCall(parent.getParent()) != null) continue;
                        return;
                    }
                    if (PsiTreeUtil.collectElements((PsiElement)presentValue, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue)).length == 0) {
                        return;
                    }
                    if (NullabilityUtil.getExpressionNullability(absentValue) == Nullability.NULLABLE || NullabilityUtil.getExpressionNullability(presentValue) == Nullability.NULLABLE) {
                        return;
                    }
                    boolean informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects((PsiElement)presentValue, ex -> condition2.extractGetCall((PsiElement)ex) != null);
                    Java8MapApiInspection.register(condition2, holder, informationLevel, new ReplaceWithSingleMapOperation("merge", (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)absentValue, PsiMethodCallExpression.class), presentValue, (PsiElement)noneBranch));
                }
            }

            private void processGetPut(Java8MigrationUtils.MapCheckCondition condition2, PsiElement result, PsiElement exists, PsiElement none) {
                PsiMethodCallExpression getCall = condition2.extractGetCall(exists);
                if (getCall == null) {
                    return;
                }
                if (!(none instanceof PsiExpression)) {
                    return;
                }
                PsiExpression noneExpression = (PsiExpression)none;
                PsiMethodCallExpression putCall = Java8MigrationUtils.extractMapMethodCall(noneExpression, "put");
                if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && putCall != null && condition2.isGetNull() && condition2.isMap((PsiElement)putCall.getMethodExpression().getQualifierExpression())) {
                    PsiExpression[] putArgs = putCall.getArgumentList().getExpressions();
                    if (putArgs.length != 2 || !condition2.isKey((PsiElement)putArgs[0]) || !ExpressionUtils.isSafelyRecomputableExpression(putArgs[1])) {
                        return;
                    }
                    Java8MapApiInspection.register(condition2, holder, false, new ReplaceWithSingleMapOperation("putIfAbsent", getCall, putArgs[1], result));
                }
                if (Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition2.isContainsKey() && ExpressionUtils.isSafelyRecomputableExpression(noneExpression) && condition2.isMapValueType(noneExpression.getType())) {
                    Java8MapApiInspection.register(condition2, holder, false, new ReplaceWithSingleMapOperation("getOrDefault", getCall, noneExpression, result));
                }
            }

            private void processSingleBranch(Java8MigrationUtils.MapCheckCondition condition2, PsiStatement noneBranch) {
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)noneBranch);
                if (assignment != null && Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition2.isContainsKey()) {
                    PsiExpression rValue = assignment.getRExpression();
                    if (ExpressionUtils.isSafelyRecomputableExpression(rValue) && condition2.isValueReference((PsiElement)assignment.getLExpression()) && !condition2.isValueReference((PsiElement)rValue) && condition2.isMapValueType(rValue.getType())) {
                        Java8MapApiInspection.register(condition2, holder, false, ReplaceWithSingleMapOperation.fromIf("getOrDefault", condition2, rValue));
                    }
                } else if (condition2.isGetNull()) {
                    PsiExpression expression2;
                    PsiExpression lambdaCandidate = Java8MigrationUtils.extractLambdaCandidate(condition2, noneBranch);
                    if (lambdaCandidate != null && Java8MapApiInspection.this.mySuggestMapComputeIfAbsent) {
                        if (NullabilityUtil.getExpressionNullability(lambdaCandidate) == Nullability.NULLABLE) {
                            return;
                        }
                        boolean informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects(lambdaCandidate);
                        Java8MapApiInspection.register(condition2, holder, informationLevel, ReplaceWithSingleMapOperation.fromIf("computeIfAbsent", condition2, lambdaCandidate));
                    }
                    if (lambdaCandidate == null && (expression2 = Java8MigrationUtils.extractPutValue(condition2, noneBranch)) != null) {
                        String replacement = null;
                        boolean informationLevel = false;
                        if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && ExpressionUtils.isSafelyRecomputableExpression(expression2) && !condition2.isValueReference((PsiElement)expression2)) {
                            replacement = "putIfAbsent";
                        } else if (Java8MapApiInspection.this.mySuggestMapComputeIfAbsent && !condition2.hasVariable()) {
                            informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects(expression2);
                            replacement = "computeIfAbsent";
                        }
                        if (replacement != null) {
                            if (condition2.hasVariable()) {
                                Java8MapApiInspection.register(condition2, holder, informationLevel, ReplaceWithSingleMapOperation.fromIf(replacement, condition2, expression2));
                            } else {
                                PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class);
                                LOG.assertTrue(call != null);
                                Java8MapApiInspection.register(condition2, holder, informationLevel, new ReplaceWithSingleMapOperation(replacement, call, expression2, (PsiElement)noneBranch));
                            }
                        }
                    }
                }
            }
        };
    }

    @NotNull
    public static String getNameCandidate(String name2) {
        if ((name2 = name2.replaceFirst("^[_\\d]+", "")).isEmpty()) {
            return "k";
        }
        String nameCandidate = name2.substring(0, 1);
        for (int pos = name2.length() - 1; pos > 0; --pos) {
            if (!Character.isUpperCase(name2.charAt(pos))) continue;
            if (pos == name2.length() - 1) break;
            nameCandidate = name2.substring(pos, pos + 1);
            break;
        }
        return StringUtil.toLowerCase((String)nameCandidate);
    }

    private static void register(Java8MigrationUtils.MapCheckCondition condition2, ProblemsHolder holder, boolean informationLevel, ReplaceWithSingleMapOperation fix) {
        if (informationLevel && !holder.isOnTheFly()) {
            return;
        }
        holder.registerProblem((PsiElement)condition2.getFullCondition(), QuickFixBundle.message("java.8.map.api.inspection.description", fix.myMethodName), informationLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
    }

    private static class ReplaceWithSingleMapOperation
    implements LocalQuickFix {
        private final String myMethodName;
        private final SmartPsiElementPointer<PsiMethodCallExpression> myCallPointer;
        private final SmartPsiElementPointer<PsiExpression> myValuePointer;
        private final SmartPsiElementPointer<PsiElement> myResultPointer;

        ReplaceWithSingleMapOperation(String methodName, PsiMethodCallExpression call, PsiExpression value2, PsiElement result) {
            this.myMethodName = methodName;
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)value2.getProject());
            this.myCallPointer = manager.createSmartPsiElementPointer((PsiElement)call);
            this.myValuePointer = manager.createSmartPsiElementPointer((PsiElement)value2);
            this.myResultPointer = manager.createSmartPsiElementPointer(result);
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)this.myCallPointer.getElement();
            PsiExpression value2 = (PsiExpression)this.myValuePointer.getElement();
            PsiElement result = this.myResultPointer.getElement();
            if (call == null || value2 == null || result == null) {
                return null;
            }
            return new ReplaceWithSingleMapOperation(this.myMethodName, (PsiMethodCallExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)call, (PsiFile)target), (PsiExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)value2, (PsiFile)target), PsiTreeUtil.findSameElementInCopy((PsiElement)result, (PsiFile)target));
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiVariable variable;
            PsiExpression replacement;
            Java8MigrationUtils.MapCondition condition2;
            PsiElement outerElement = PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class, PsiForeachStatement.class});
            if (outerElement == null) {
                return;
            }
            Java8MigrationUtils.MapCondition mapCondition = condition2 = outerElement instanceof PsiForeachStatement ? Java8MigrationUtils.MapLoopCondition.create((PsiForeachStatement)outerElement) : Java8MigrationUtils.MapCheckCondition.fromConditional(outerElement, true);
            if (condition2 == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)this.myCallPointer.getElement();
            if (call == null) {
                return;
            }
            PsiExpressionList argsList = call.getArgumentList();
            PsiExpression[] args = argsList.getExpressions();
            if (args.length == 0) {
                return;
            }
            if ((this.myMethodName.equals("merge") || this.myMethodName.equals("replaceAll")) && args.length != 2) {
                return;
            }
            PsiExpression value2 = (PsiExpression)this.myValuePointer.getElement();
            if (value2 == null) {
                return;
            }
            PsiElement result = this.myResultPointer.getElement();
            if (result == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo(call, this.myMethodName);
            if (this.myMethodName.equals("computeIfAbsent")) {
                PsiMethod method;
                PsiExpression key2 = args[0];
                List<Object> refs = Collections.emptyList();
                String nameCandidate = "k";
                if (key2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)key2).getQualifier() == null && (method = call.resolveMethod()) != null) {
                    PsiType argType = method.getParameterList().getParameters()[0].getType();
                    PsiType mapKeyType = call.resolveMethodGenerics().getSubstitutor().substitute(argType);
                    PsiType keyType = key2.getType();
                    if (mapKeyType != null && keyType != null && keyType.isAssignableFrom(mapKeyType)) {
                        PsiElement target = ((PsiReferenceExpression)key2).resolve();
                        List<Object> list = refs = target == null ? Collections.emptyList() : ((StreamEx)StreamEx.of((Collection)PsiTreeUtil.collectElementsOfType((PsiElement)value2, (Class[])new Class[]{PsiReferenceExpression.class})).filter(ref -> ref.getQualifierExpression() == null && ref.isReferenceTo(target))).toList();
                        if (!refs.isEmpty()) {
                            nameCandidate = Java8MapApiInspection.getNameCandidate(((PsiReferenceExpression)key2).getReferenceName());
                        }
                    }
                }
                String varName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(nameCandidate, (PsiElement)value2, true);
                for (PsiReferenceExpression ref2 : refs) {
                    ExpressionUtils.bindReferenceTo(ref2, varName);
                }
                replacement = factory.createExpressionFromText(varName + " -> " + ct.text((PsiElement)value2), (PsiElement)value2);
            } else if (this.myMethodName.equals("merge")) {
                Java8MigrationUtils.MapCheckCondition checkCondition = (Java8MigrationUtils.MapCheckCondition)ObjectUtils.tryCast((Object)condition2, Java8MigrationUtils.MapCheckCondition.class);
                if (checkCondition == null) {
                    return;
                }
                PsiExpression absentValue = args[1];
                String aVar = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("a", (PsiElement)value2, true);
                String bVar = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("b", (PsiElement)value2, true);
                for (PsiElement e2 : PsiTreeUtil.collectElements((PsiElement)value2, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue))) {
                    ct.replace(e2, (PsiElement)factory.createIdentifier(bVar));
                }
                for (PsiElement e2 : PsiTreeUtil.collectElements((PsiElement)value2, e -> checkCondition.extractGetCall(e) != null || checkCondition.isValueReference(e))) {
                    ct.replace(e2, (PsiElement)factory.createIdentifier(aVar));
                }
                replacement = factory.createExpressionFromText("(" + aVar + "," + bVar + ") -> " + ct.text((PsiElement)value2), (PsiElement)value2);
            } else if (this.myMethodName.equals("replaceAll")) {
                Java8MigrationUtils.MapLoopCondition loopCondition = (Java8MigrationUtils.MapLoopCondition)ObjectUtils.tryCast((Object)condition2, Java8MigrationUtils.MapLoopCondition.class);
                if (loopCondition == null) {
                    return;
                }
                String kVar = ReplaceWithSingleMapOperation.suggestKeyName(loopCondition, (PsiElement)value2);
                String vVar = new VariableNameGenerator((PsiElement)value2, VariableKind.PARAMETER).byName("v", "value").generate(true);
                replacement = ReplaceWithSingleMapOperation.createLambdaForLoopReplacement(factory, kVar, vVar, loopCondition, value2, ct);
                ct.delete((PsiElement[])args);
            } else {
                replacement = ct.markUnchanged(value2);
            }
            PsiElement newArg = args.length == 2 && !this.myMethodName.equals("merge") && !this.myMethodName.equals("replaceAll") ? ct.replace((PsiElement)args[1], (PsiElement)replacement) : argsList.add((PsiElement)replacement);
            if (newArg instanceof PsiLambdaExpression) {
                LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)newArg);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)outerElement, (PsiElement)result, (boolean)true)) {
                result = ct.replaceAndRestoreComments(outerElement, result);
            } else {
                ct.deleteAndRestoreComments(outerElement);
            }
            PsiVariable psiVariable = variable = condition2 instanceof Java8MigrationUtils.MapCheckCondition ? ((Java8MigrationUtils.MapCheckCondition)condition2).extractDeclaration() : null;
            if (variable != null && !PsiTreeUtil.isAncestor((PsiElement)result, (PsiElement)variable, (boolean)true) && ReferencesSearch.search((PsiElement)variable).findFirst() == null) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)variable);
            }
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static String suggestKeyName(@NotNull Java8MigrationUtils.MapLoopCondition loopCondition, @NotNull PsiElement value2) {
            VariableNameGenerator generator = new VariableNameGenerator(value2, VariableKind.PARAMETER);
            if (!loopCondition.isEntrySet()) {
                String nameCandidate;
                String origName = loopCondition.getIterParam().getName();
                if (origName.equals(nameCandidate = Java8MapApiInspection.getNameCandidate(origName))) {
                    return nameCandidate;
                }
                generator.byName(nameCandidate);
            }
            return generator.byName("k", "key").generate(true);
        }

        @NotNull
        private static PsiExpression createLambdaForLoopReplacement(@NotNull PsiElementFactory factory, @NotNull String kVar, @NotNull String vVar, @NotNull Java8MigrationUtils.MapLoopCondition loopCondition, @NotNull PsiExpression value2, @NotNull CommentTracker tracker) {
            if (value2 instanceof PsiMethodCallExpression) {
                if (loopCondition.isKeyAccess(value2)) {
                    return factory.createExpressionFromText("(" + kVar + "," + vVar + ") ->" + kVar, (PsiElement)value2);
                }
                if (loopCondition.isValueAccess(value2)) {
                    return factory.createExpressionFromText("(" + kVar + "," + vVar + ") ->" + vVar, (PsiElement)value2);
                }
            }
            if (!loopCondition.isEntrySet()) {
                PsiParameter param = loopCondition.getIterParam();
                VariableAccessUtils.getVariableReferences((PsiVariable)param, (PsiElement)value2).forEach(ref -> ExpressionUtils.bindReferenceTo(ref, kVar));
            }
            Collection calls = PsiTreeUtil.collectElementsOfType((PsiElement)value2, (Class[])new Class[]{PsiMethodCallExpression.class});
            for (PsiMethodCallExpression call : calls) {
                if (loopCondition.isKeyAccess((PsiExpression)call)) {
                    tracker.replace((PsiElement)call, kVar);
                    continue;
                }
                if (!loopCondition.isValueAccess((PsiExpression)call)) continue;
                tracker.replace((PsiElement)call, vVar);
            }
            return factory.createExpressionFromText("(" + kVar + "," + vVar + ") ->" + tracker.text((PsiElement)value2), (PsiElement)value2);
        }

        @Nls
        @NotNull
        public String getName() {
            return QuickFixBundle.message("java.8.map.api.inspection.fix.text", this.myMethodName);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("java.8.map.api.inspection.fix.family.name", new Object[0]);
        }

        @NotNull
        static ReplaceWithSingleMapOperation fromIf(String methodName, Java8MigrationUtils.MapCheckCondition condition2, PsiExpression value2) {
            PsiMethodCallExpression call = condition2.getCheckCall();
            return ReplaceWithSingleMapOperation.create(methodName, call, value2);
        }

        @NotNull
        static ReplaceWithSingleMapOperation create(String methodName, PsiMethodCallExpression call, PsiExpression value2) {
            PsiStatement result = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiStatement.class);
            LOG.assertTrue(result != null);
            return new ReplaceWithSingleMapOperation(methodName, call, value2, (PsiElement)result);
        }
    }
}

