/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.enhancedSwitch;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SwitchLabeledRuleCanBeCodeBlockInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!HighlightingFeature.ENHANCED_SWITCH.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
                super.visitSwitchLabeledRuleStatement(statement);
                PsiSwitchBlock switchBlock = statement.getEnclosingSwitchBlock();
                PsiStatement body2 = statement.getBody();
                if (switchBlock != null && (body2 instanceof PsiExpressionStatement || body2 instanceof PsiThrowStatement)) {
                    if (switchBlock instanceof PsiSwitchExpression && body2 instanceof PsiExpressionStatement) {
                        this.registerProblem(statement, true);
                    } else {
                        this.registerProblem(statement, false);
                    }
                }
            }

            private void registerProblem(@NotNull PsiSwitchLabeledRuleStatement statement, boolean isResultExpression) {
                holder.registerProblem(this.getProblemElement(statement), JavaBundle.message((String)(isResultExpression ? "inspection.switch.labeled.rule.can.be.code.block.expression.message" : "inspection.switch.labeled.rule.can.be.code.block.statement.message"), (Object[])new Object[0]), new LocalQuickFix[]{new WrapWithCodeBlockFix(isResultExpression)});
            }

            @NotNull
            private PsiElement getProblemElement(@NotNull PsiSwitchLabeledRuleStatement statement) {
                if (isOnTheFly && (InspectionProjectProfileManager.isInformationLevel((String)SwitchLabeledRuleCanBeCodeBlockInspection.this.getShortName(), (PsiElement)statement) || ApplicationManager.getApplication().isUnitTestMode())) {
                    return statement;
                }
                return (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)statement.getFirstChild(), PsiKeyword.class), (Object)statement);
            }
        };
    }

    private static class WrapWithCodeBlockFix
    implements LocalQuickFix {
        private final String myMessage;

        WrapWithCodeBlockFix(boolean isResultExpression) {
            this.myMessage = JavaBundle.message((String)(isResultExpression ? "inspection.switch.labeled.rule.can.be.code.block.fix.expression.name" : "inspection.switch.labeled.rule.can.be.code.block.fix.statement.name"), (Object[])new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return this.myMessage;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            if (element instanceof PsiKeyword) {
                element = element.getParent();
            }
            if (element instanceof PsiSwitchLabeledRuleStatement) {
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)element;
                PsiSwitchBlock switchBlock = rule.getEnclosingSwitchBlock();
                PsiStatement body2 = rule.getBody();
                if (switchBlock instanceof PsiSwitchExpression && body2 instanceof PsiExpressionStatement) {
                    WrapWithCodeBlockFix.wrapExpression((PsiExpressionStatement)body2);
                } else if (body2 != null) {
                    WrapWithCodeBlockFix.wrapStatement(body2);
                }
            }
        }

        private static void wrapExpression(PsiExpressionStatement expressionStatement) {
            CommentTracker tracker = new CommentTracker();
            String valueKeyword = "yield";
            tracker.replaceAndRestoreComments((PsiElement)expressionStatement, "{ " + valueKeyword + " " + tracker.text((PsiElement)expressionStatement) + "\n }");
        }

        private static void wrapStatement(@NotNull PsiStatement statement) {
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)statement, "{ " + tracker.text((PsiElement)statement) + "\n }");
        }
    }
}

