/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.deprecation.DeprecationInspectionQuickFixesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0096\u0002R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInspection/deprecation/ReplaceFieldReferenceFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "expr", "Lcom/intellij/psi/PsiReferenceExpression;", "replacementField", "Lcom/intellij/psi/PsiField;", "(Lcom/intellij/psi/PsiReferenceExpression;Lcom/intellij/psi/PsiField;)V", "myReplacementMethodPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myReplacementText", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.java.analysis.impl"})
public final class ReplaceFieldReferenceFix
extends LocalQuickFixOnPsiElement {
    private final SmartPsiElementPointer<PsiField> myReplacementMethodPointer;
    private final String myReplacementText;

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("replace.field.reference.fix.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return InspectionGadgetsBundle.message("replace.field.reference.fix.text", this.myReplacementText);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)startElement, PsiReferenceExpression.class);
        if (psiReferenceExpression == null) {
            return;
        }
        PsiReferenceExpression expr2 = psiReferenceExpression;
        PsiField psiField = (PsiField)this.myReplacementMethodPointer.getElement();
        if (psiField == null) {
            return;
        }
        PsiField replacementField = psiField;
        String qualifierText = DeprecationInspectionQuickFixesKt.access$generateQualifierText(expr2, (PsiMember)replacementField);
        PsiElement replaced = expr2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(qualifierText + replacementField.getName(), (PsiElement)expr2));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
    }

    public ReplaceFieldReferenceFix(@NotNull PsiReferenceExpression expr2, @NotNull PsiField replacementField) {
        super((PsiElement)expr2);
        this.myReplacementMethodPointer = SmartPointerManager.getInstance((Project)replacementField.getProject()).createSmartPsiElementPointer((PsiElement)replacementField);
        this.myReplacementText = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)replacementField), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }
}

