/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaCondition {
    DfaCondition() {
    }

    @NotNull
    @Contract(pure=true)
    public abstract DfaCondition negate();

    @Contract(pure=true)
    public static DfaCondition getTrue() {
        return Exact.TRUE;
    }

    @Contract(pure=true)
    public static DfaCondition getFalse() {
        return Exact.FALSE;
    }

    @Contract(pure=true)
    public static DfaCondition getUnknown() {
        return Exact.UNKNOWN;
    }

    @NotNull
    static DfaCondition createCondition(@NotNull DfaValue left, @NotNull RelationType relationType, @NotNull DfaValue right) {
        Exact value2 = Exact.tryEvaluate(left, relationType, right);
        if (value2 != null) {
            return value2;
        }
        DfaRelation relation = DfaRelation.createRelation(left, relationType, right);
        if (relation != null) {
            return relation;
        }
        return Exact.UNKNOWN;
    }

    static class Exact
    extends DfaCondition {
        private final String myName;
        static final Exact TRUE = new Exact("TRUE");
        static final Exact FALSE = new Exact("FALSE");
        static final Exact UNKNOWN = new Exact("UNKNOWN");

        private Exact(String name2) {
            this.myName = name2;
        }

        public String toString() {
            return this.myName;
        }

        @Override
        @NotNull
        public DfaCondition negate() {
            if (this == TRUE) {
                return FALSE;
            }
            if (this == FALSE) {
                return TRUE;
            }
            return UNKNOWN;
        }

        private static Exact fromBoolean(boolean value2) {
            return value2 ? TRUE : FALSE;
        }

        @Nullable
        static Exact tryEvaluate(DfaValue dfaLeft, RelationType relationType, DfaValue dfaRight) {
            DfaValue sentinel = dfaLeft.getFactory().getSentinel();
            if (dfaLeft == sentinel || dfaRight == sentinel) {
                return Exact.fromBoolean((dfaLeft == sentinel && dfaRight == sentinel) == (relationType == RelationType.EQ));
            }
            DfType leftType = dfaLeft.getDfType();
            DfType rightType = dfaRight.getDfType();
            if (relationType == RelationType.EQ || relationType == RelationType.NE) {
                if (leftType instanceof DfConstantType) {
                    if (rightType instanceof DfConstantType) {
                        return Exact.fromBoolean(leftType.equals(rightType) ^ !DfaUtil.isNaN(((DfConstantType)leftType).getValue()) ^ relationType == RelationType.EQ);
                    }
                    if (!Exact.couldBeEqualToConstant(rightType, leftType)) {
                        return Exact.fromBoolean(relationType == RelationType.NE);
                    }
                } else if (rightType instanceof DfConstantType ? !Exact.couldBeEqualToConstant(leftType, rightType) : leftType.meet(rightType) == DfTypes.BOTTOM) {
                    return Exact.fromBoolean(relationType == RelationType.NE);
                }
            }
            if (relationType == RelationType.IS || relationType == RelationType.IS_NOT) {
                boolean isDistinct;
                boolean isSuperState = rightType.isSuperType(leftType);
                if (isSuperState) {
                    return Exact.fromBoolean(relationType == RelationType.IS);
                }
                boolean bl = isDistinct = rightType.meet(leftType) == DfTypes.BOTTOM;
                if (isDistinct) {
                    return Exact.fromBoolean(relationType == RelationType.IS_NOT);
                }
            }
            if (leftType instanceof DfIntegralType && rightType instanceof DfIntegralType) {
                if (((DfIntegralType)leftType).meetRelation(relationType, rightType) == DfTypes.BOTTOM) {
                    return FALSE;
                }
                if (((DfIntegralType)leftType).meetRelation(relationType.getNegated(), rightType) == DfTypes.BOTTOM) {
                    return TRUE;
                }
            }
            return null;
        }

        private static boolean couldBeEqualToConstant(DfType type2, DfType constantType) {
            return (type2 instanceof DfReferenceType ? ((DfReferenceType)type2).dropTypeConstraint() : type2).isSuperType(constantType);
        }
    }
}

