/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiType;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBoxedValue
extends DfaValue {
    @NotNull
    private final DfaVariableValue myWrappedValue;
    @Nullable
    private final PsiType myType;

    private DfaBoxedValue(@NotNull DfaVariableValue valueToWrap, @NotNull DfaValueFactory factory, @Nullable PsiType type2) {
        super(factory);
        this.myWrappedValue = valueToWrap;
        this.myType = type2;
    }

    @NonNls
    public String toString() {
        return "Boxed " + this.myWrappedValue.toString();
    }

    @NotNull
    public DfaVariableValue getWrappedValue() {
        return this.myWrappedValue;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @Override
    @NotNull
    public DfType getDfType() {
        return DfTypes.typedObject(this.myType, Nullability.NOT_NULL);
    }

    public static class Factory {
        private final TIntObjectHashMap<DfaBoxedValue> cachedValues = new TIntObjectHashMap();
        private final DfaValueFactory myFactory;

        public Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @Nullable
        public DfaValue createBoxed(DfaValue valueToWrap, @Nullable PsiType type2) {
            DfaVariableValue qualifier;
            if (valueToWrap instanceof DfaVariableValue && ((DfaVariableValue)valueToWrap).getDescriptor() == SpecialField.UNBOX && (qualifier = ((DfaVariableValue)valueToWrap).getQualifier()) != null && (type2 == null || type2.equals(qualifier.getType()))) {
                return qualifier;
            }
            if (valueToWrap instanceof DfaTypeValue) {
                DfType dfType = SpecialField.UNBOX.asDfType(valueToWrap.getDfType(), type2);
                return this.myFactory.fromDfType(dfType);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                int id = valueToWrap.getID();
                DfaBoxedValue boxedValue = (DfaBoxedValue)this.cachedValues.get(id);
                if (boxedValue == null) {
                    boxedValue = new DfaBoxedValue((DfaVariableValue)valueToWrap, this.myFactory, type2);
                    this.cachedValues.put(id, (Object)boxedValue);
                }
                return boxedValue;
            }
            return null;
        }
    }
}

