/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DfReferenceType
extends DfType {
    @NotNull
    public DfaNullability getNullability();

    @NotNull
    public TypeConstraint getConstraint();

    @NotNull
    default public Mutability getMutability() {
        return Mutability.UNKNOWN;
    }

    default public boolean isLocal() {
        return false;
    }

    @Nullable
    default public SpecialField getSpecialField() {
        return null;
    }

    @NotNull
    default public DfType getSpecialFieldType() {
        return DfTypes.BOTTOM;
    }

    @NotNull
    default public DfReferenceType dropTypeConstraint() {
        return this;
    }

    @NotNull
    default public DfReferenceType dropLocality() {
        return this;
    }

    @NotNull
    public DfReferenceType dropNullability();

    @NotNull
    default public DfReferenceType dropMutability() {
        return this;
    }

    default public DfReferenceType dropSpecialField() {
        return this;
    }

    public static boolean isLocal(DfType type2) {
        return type2 instanceof DfReferenceType && ((DfReferenceType)type2).isLocal();
    }

    @NotNull
    default public DfType withoutType(@NotNull TypeConstraint type2) {
        TypeConstraint constraint = this.getConstraint();
        if (constraint.equals(type2)) {
            return this.dropTypeConstraint();
        }
        if (type2 instanceof TypeConstraint.Exact) {
            TypeConstraint.Exact exact = (TypeConstraint.Exact)type2;
            TypeConstraint result = TypeConstraints.TOP;
            result = (TypeConstraint)constraint.instanceOfTypes().without((Object)exact).map(TypeConstraint.Exact::instanceOf).foldLeft((Object)result, TypeConstraint::meet);
            result = (TypeConstraint)constraint.notInstanceOfTypes().without((Object)exact).map(TypeConstraint.Exact::notInstanceOf).foldLeft((Object)result, TypeConstraint::meet);
            return this.dropTypeConstraint().meet(result.asDfType());
        }
        return this;
    }
}

