/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfGenericObjectType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfReferenceConstantType
extends DfConstantType<Object>
implements DfReferenceType {
    @NotNull
    private final PsiType myPsiType;
    @NotNull
    private final TypeConstraint myConstraint;
    @NotNull
    private final Mutability myMutability;
    @Nullable
    private final SpecialField mySpecialField;
    @NotNull
    private final DfType mySpecialFieldType;

    DfReferenceConstantType(@NotNull Object constant, @NotNull PsiType psiType, @NotNull TypeConstraint type2) {
        super(constant);
        this.myPsiType = psiType;
        this.myConstraint = type2;
        this.myMutability = constant instanceof PsiModifierListOwner ? Mutability.getMutability((PsiModifierListOwner)constant) : Mutability.UNKNOWN;
        this.mySpecialField = SpecialField.fromQualifierType(psiType);
        this.mySpecialFieldType = this.mySpecialField == null ? DfTypes.BOTTOM : this.mySpecialField.fromConstant(constant);
    }

    @Override
    @NotNull
    public DfType meet(@NotNull DfType other) {
        if (other.isSuperType(this)) {
            return this;
        }
        if (other instanceof DfGenericObjectType) {
            DfReferenceConstantType subConstant;
            DfReferenceType type2 = ((DfReferenceType)other).dropMutability();
            if (type2.isSuperType(this)) {
                return this;
            }
            TypeConstraint constraint = type2.getConstraint().meet(this.myConstraint);
            if (constraint != TypeConstraints.BOTTOM && type2.isSuperType(subConstant = new DfReferenceConstantType(this.getValue(), this.myPsiType, constraint))) {
                return subConstant;
            }
        }
        return DfTypes.BOTTOM;
    }

    @Override
    @NotNull
    public PsiType getPsiType() {
        return this.myPsiType;
    }

    @Override
    @NotNull
    public DfaNullability getNullability() {
        return DfaNullability.NOT_NULL;
    }

    @Override
    @NotNull
    public TypeConstraint getConstraint() {
        return this.myConstraint;
    }

    @Override
    @NotNull
    public Mutability getMutability() {
        return this.myMutability;
    }

    @Override
    @Nullable
    public SpecialField getSpecialField() {
        return this.mySpecialField;
    }

    @Override
    @NotNull
    public DfType getSpecialFieldType() {
        return this.mySpecialFieldType;
    }

    @Override
    public DfType tryNegate() {
        return new DfGenericObjectType(Collections.singleton(this.getValue()), TypeConstraints.TOP, DfaNullability.UNKNOWN, Mutability.UNKNOWN, null, DfTypes.BOTTOM, false);
    }

    @Override
    @NotNull
    public DfReferenceType dropNullability() {
        return this;
    }

    @Override
    @NotNull
    public DfType join(@NotNull DfType other) {
        if (other instanceof DfGenericObjectType) {
            return other.join(this);
        }
        if (this.isSuperType(other)) {
            return this;
        }
        if (other.isSuperType(this)) {
            return other;
        }
        if (!(other instanceof DfReferenceType)) {
            return DfTypes.TOP;
        }
        DfReferenceType type2 = (DfReferenceType)other;
        TypeConstraint constraint = this.getConstraint().join(type2.getConstraint());
        DfaNullability nullability = this.getNullability().unite(type2.getNullability());
        Mutability mutability = this.getMutability().unite(type2.getMutability());
        boolean locality = this.isLocal() && type2.isLocal();
        SpecialField sf = Objects.equals(this.getSpecialField(), type2.getSpecialField()) ? this.getSpecialField() : null;
        DfType sfType = sf == null ? DfTypes.BOTTOM : this.getSpecialFieldType().join(type2.getSpecialFieldType());
        return new DfGenericObjectType(Collections.emptySet(), constraint, nullability, mutability, sf, sfType, locality);
    }
}

