/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DfLongType
extends DfIntegralType {
    @Override
    @NotNull
    public LongRangeSet getRange();

    @Override
    @NotNull
    default public DfType join(@NotNull DfType other) {
        if (!(other instanceof DfLongType)) {
            return DfTypes.TOP;
        }
        return DfTypes.longRange(((DfLongType)other).getRange().unite(this.getRange()));
    }

    @Override
    @NotNull
    default public DfType meet(@NotNull DfType other) {
        if (other == DfTypes.TOP) {
            return this;
        }
        if (!(other instanceof DfLongType)) {
            return DfTypes.BOTTOM;
        }
        return DfTypes.longRange(((DfLongType)other).getRange().intersect(this.getRange()));
    }

    @Override
    @NotNull
    default public DfType meetRange(@NotNull LongRangeSet range) {
        return this.meet(DfTypes.longRange(range));
    }

    @Override
    @NotNull
    default public PsiPrimitiveType getPsiType() {
        return PsiType.LONG;
    }

    @Override
    @Nullable
    default public DfType tryNegate() {
        LongRangeSet range = this.getRange();
        LongRangeSet res = LongRangeSet.all().subtract(range);
        return res.intersects(range) ? null : DfTypes.longRange(res);
    }

    @NotNull
    public static LongRangeSet extractRange(@NotNull DfType type2) {
        return type2 instanceof DfIntegralType ? ((DfIntegralType)type2).getRange() : LongRangeSet.all();
    }
}

