/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

class DfLongRangeType
implements DfLongType {
    private final LongRangeSet myRange;

    DfLongRangeType(LongRangeSet range) {
        this.myRange = range;
    }

    @Override
    @NotNull
    public LongRangeSet getRange() {
        return this.myRange;
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        if (other == DfTypes.BOTTOM) {
            return true;
        }
        if (!(other instanceof DfLongType)) {
            return false;
        }
        return this.myRange.contains(((DfLongType)other).getRange());
    }

    public int hashCode() {
        return this.myRange.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DfLongRangeType && ((DfLongRangeType)obj).myRange.equals(this.myRange);
    }

    public String toString() {
        if (this.myRange == LongRangeSet.all()) {
            return "long";
        }
        return "long " + this.myRange.getPresentationText((PsiType)PsiType.LONG);
    }
}

