/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class AssertAllInliner
implements CallInliner {
    private static final CallMatcher ASSERT_ALL = CallMatcher.anyOf(CallMatcher.staticCall("org.junit.jupiter.api.Assertions", "assertAll").parameterTypes("org.junit.jupiter.api.function.Executable..."), CallMatcher.staticCall("org.junit.jupiter.api.Assertions", "assertAll").parameterTypes("java.lang.String", "org.junit.jupiter.api.function.Executable..."));

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (!ASSERT_ALL.matches((PsiExpression)call) || !MethodCallUtils.isVarArgCall((PsiCall)call)) {
            return false;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = args[i];
            if (i == 0 && TypeUtils.isJavaLangString(arg.getType())) {
                builder.pushExpression(arg, NullabilityProblemKind.noProblem).pop();
                continue;
            }
            builder.evaluateFunction(arg);
        }
        DfaVariableValue result = builder.createTempVariable((PsiType)PsiType.BOOLEAN);
        builder.assignAndPop(result, DfTypes.FALSE);
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = args[i];
            if (i == 0 && TypeUtils.isJavaLangString(arg.getType())) continue;
            builder.doTry((PsiElement)call).invokeFunction(0, arg).catchAll().assignAndPop(result, DfTypes.TRUE).end();
        }
        PsiClassType throwable = JavaPsiFacade.getElementFactory((Project)call.getProject()).createTypeByFQClassName("org.opentest4j.MultipleFailuresError", call.getResolveScope());
        builder.push(result).ifConditionIs(true).doThrow((PsiType)throwable).end().pushUnknown();
        return true;
    }
}

