/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.DefaultInferredAnnotationProvider;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodContractUtil {
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();

    private JavaMethodContractUtil() {
    }

    @NotNull
    public static List<? extends MethodContract> getMethodCallContracts(@NotNull PsiCallExpression call) {
        PsiMethod method = call.resolveMethod();
        return method == null ? Collections.emptyList() : JavaMethodContractUtil.getMethodCallContracts(method, call);
    }

    @NotNull
    public static List<? extends MethodContract> getMethodCallContracts(@NotNull PsiMethod method, @Nullable PsiCallExpression call) {
        List<MethodContract> hardcoded = HardcodedContracts.getHardcodedContracts(method, (PsiMethodCallExpression)ObjectUtils.tryCast((Object)call, PsiMethodCallExpression.class));
        if (!hardcoded.isEmpty()) {
            NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)method);
            if (info == null || info.isExternal() || info.getNullability() != Nullability.NOT_NULL) {
                return hardcoded;
            }
            if (HardcodedContracts.getHardcodedContracts(method, null).isEmpty()) {
                return hardcoded;
            }
        }
        return JavaMethodContractUtil.getMethodContracts(method);
    }

    @NotNull
    public static List<StandardMethodContract> getMethodContracts(@NotNull PsiMethod method) {
        return JavaMethodContractUtil.getContractInfo(method).getContracts();
    }

    public static boolean hasExplicitContractAnnotation(@NotNull PsiMethod method) {
        return JavaMethodContractUtil.getContractInfo(method).isExplicit();
    }

    @Nullable
    public static PsiAnnotation updateContract(PsiAnnotation annotation, List<StandardMethodContract> contracts2) {
        boolean pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure"));
        String mutates = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"mutates"));
        String resultValue = StreamEx.of(contracts2).joining((CharSequence)"; ");
        Project project = annotation.getProject();
        return DefaultInferredAnnotationProvider.createContractAnnotation(project, pure, resultValue, mutates);
    }

    @NotNull
    static ContractInfo getContractInfo(@NotNull PsiMethod method) {
        if (PsiUtil.isAnnotationMethod((PsiElement)method) || method instanceof LightRecordMethod) {
            return ContractInfo.PURE;
        }
        return (ContractInfo)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            PsiAnnotation contractAnno = JavaMethodContractUtil.findContractAnnotation(method);
            ContractInfo info = ContractInfo.EMPTY;
            if (contractAnno != null) {
                List<StandardMethodContract> contracts2 = JavaMethodContractUtil.parseContracts(method, contractAnno);
                boolean pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)contractAnno, (String)"pure"));
                MutationSignature mutationSignature = MutationSignature.UNKNOWN;
                if (pure) {
                    mutationSignature = MutationSignature.PURE;
                } else {
                    String mutationText = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, (String)"mutates");
                    if (mutationText != null) {
                        try {
                            mutationSignature = MutationSignature.parse(mutationText);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                boolean explicit = !AnnotationUtil.isInferredAnnotation((PsiAnnotation)contractAnno);
                info = new ContractInfo(contracts2, pure, explicit, mutationSignature);
            }
            return CachedValueProvider.Result.create((Object)info, (Object[])new Object[]{method, PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    public static List<StandardMethodContract> parseContracts(@NotNull PsiMethod method, @Nullable PsiAnnotation contractAnno) {
        if (contractAnno == null) {
            return Collections.emptyList();
        }
        String text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, null);
        if (text2 != null) {
            try {
                int paramCount = method.getParameterList().getParametersCount();
                List<StandardMethodContract> parsed = StandardMethodContract.parseContract(text2);
                if (parsed.stream().allMatch(c -> c.getParameterCount() == paramCount)) {
                    return parsed;
                }
            }
            catch (StandardMethodContract.ParseException parseException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method) {
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
    }

    public static boolean isPure(@NotNull PsiMethod method) {
        return JavaMethodContractUtil.getContractInfo(method).isPure();
    }

    @Nullable
    public static ContractReturnValue getNonFailingReturnValue(List<? extends MethodContract> contracts2) {
        ArrayList<ContractValue> failConditions = new ArrayList<ContractValue>();
        for (MethodContract methodContract : contracts2) {
            List<ContractValue> conditions = methodContract.getConditions();
            if (conditions.isEmpty() || conditions.stream().allMatch(c -> failConditions.stream().anyMatch(c::isExclusive))) {
                return methodContract.getReturnValue();
            }
            if (!methodContract.getReturnValue().isFail()) break;
            if (conditions.size() != 1) continue;
            failConditions.add(conditions.get(0));
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression findReturnedValue(@Nullable PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
        ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
        if (returnValue == null) {
            return null;
        }
        if (returnValue.equals(ContractReturnValue.returnThis())) {
            return ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
        }
        if (returnValue instanceof ContractReturnValue.ParameterReturnValue) {
            int number = ((ContractReturnValue.ParameterReturnValue)returnValue).getParameterNumber();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length <= number) {
                return null;
            }
            if (args.length == number + 1 && MethodCallUtils.isVarArgCall((PsiCall)call)) {
                return null;
            }
            return args[number];
        }
        return null;
    }

    static class ContractInfo {
        static final ContractInfo EMPTY = new ContractInfo(Collections.emptyList(), false, false, MutationSignature.UNKNOWN);
        static final ContractInfo PURE = new ContractInfo(Collections.emptyList(), true, false, MutationSignature.PURE);
        @NotNull
        private final List<StandardMethodContract> myContracts;
        private final boolean myPure;
        private final boolean myExplicit;
        @NotNull
        private final MutationSignature myMutationSignature;

        ContractInfo(@NotNull List<StandardMethodContract> contracts2, boolean pure, boolean explicit, @NotNull MutationSignature signature) {
            this.myContracts = contracts2;
            this.myPure = pure;
            this.myExplicit = explicit;
            this.myMutationSignature = signature;
        }

        @NotNull
        List<StandardMethodContract> getContracts() {
            return this.myContracts;
        }

        boolean isPure() {
            return this.myPure;
        }

        boolean isExplicit() {
            return this.myExplicit;
        }

        @NotNull
        MutationSignature getMutationSignature() {
            return this.myMutationSignature;
        }
    }
}

