/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DistinctPairSet
extends AbstractSet<DistinctPair> {
    private final DfaMemoryStateImpl myState;
    private final TLongHashSet myData;

    DistinctPairSet(DfaMemoryStateImpl state) {
        this.myState = state;
        this.myData = new TLongHashSet();
    }

    DistinctPairSet(DfaMemoryStateImpl state, DistinctPairSet other) {
        this.myData = new TLongHashSet(other.size());
        this.myState = state;
        other.myData.forEach(arg_0 -> ((TLongHashSet)this.myData).add(arg_0));
    }

    boolean addOrdered(int firstIndex, int secondIndex) {
        TLongHashSet toAdd = new TLongHashSet();
        toAdd.add(DistinctPairSet.createPair(firstIndex, secondIndex, true));
        for (DistinctPair pair2 : this) {
            if (!pair2.isOrdered()) continue;
            if (pair2.myFirst == secondIndex) {
                if (pair2.mySecond == firstIndex || this.myData.contains(DistinctPairSet.createPair(pair2.mySecond, firstIndex, true))) {
                    return false;
                }
                toAdd.add(DistinctPairSet.createPair(firstIndex, pair2.mySecond, true));
                continue;
            }
            if (pair2.mySecond != firstIndex) continue;
            if (this.myData.contains(DistinctPairSet.createPair(secondIndex, pair2.myFirst, true))) {
                return false;
            }
            toAdd.add(DistinctPairSet.createPair(pair2.myFirst, secondIndex, true));
        }
        this.myData.addAll(toAdd.toArray());
        return true;
    }

    void addUnordered(int firstIndex, int secondIndex) {
        if (!this.myData.contains(DistinctPairSet.createPair(firstIndex, secondIndex, true)) && !this.myData.contains(DistinctPairSet.createPair(secondIndex, firstIndex, true))) {
            this.myData.add(DistinctPairSet.createPair(firstIndex, secondIndex, false));
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof DistinctPair) {
            DistinctPair dp = (DistinctPair)o;
            return this.myData.remove(DistinctPairSet.createPair(dp.myFirst, dp.mySecond, dp.myOrdered));
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof DistinctPair)) {
            return false;
        }
        DistinctPair dp = (DistinctPair)o;
        EqClass first = dp.getFirst();
        EqClass second = dp.getSecond();
        if (first.isEmpty() || second.isEmpty()) {
            return false;
        }
        int firstVal = first.get(0);
        int secondVal = second.get(0);
        int firstIndex = this.myState.getEqClassIndex(this.myState.getFactory().getValue(firstVal));
        if (firstIndex == -1) {
            return false;
        }
        int secondIndex = this.myState.getEqClassIndex(this.myState.getFactory().getValue(secondVal));
        if (secondIndex == -1) {
            return false;
        }
        long pair2 = DistinctPairSet.createPair(firstIndex, secondIndex, dp.isOrdered());
        return this.myData.contains(pair2) && this.decode(pair2).equals(dp);
    }

    @Override
    public Iterator<DistinctPair> iterator() {
        return new Iterator<DistinctPair>(){
            final TLongIterator iterator;
            {
                this.iterator = DistinctPairSet.this.myData.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public DistinctPair next() {
                return DistinctPairSet.this.decode(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.myData.size();
    }

    public boolean unite(int c1Index, int c2Index) {
        long[] distincts;
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myData.toArray()) {
            int pc1 = DistinctPairSet.low(distinct);
            int pc2 = DistinctPairSet.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
                if (distinct < 0L && (pc1 == c1Index && this.myData.contains(DistinctPairSet.createPair(pc2, c2Index, true)) || pc2 == c1Index && this.myData.contains(DistinctPairSet.createPair(c2Index, pc1, true)))) {
                    return false;
                }
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        for (int i = 0; i < c2Pairs.size(); ++i) {
            long c = c2Pairs.get(i);
            this.myData.remove(c);
            if (c >= 0L) {
                this.myData.add(DistinctPairSet.createPair(c1Index, DistinctPairSet.low(c) == c2Index ? DistinctPairSet.high(c) : DistinctPairSet.low(c), false));
                continue;
            }
            if (DistinctPairSet.low(c) == c2Index) {
                this.myData.add(DistinctPairSet.createPair(c1Index, DistinctPairSet.high(c), true));
                continue;
            }
            this.myData.add(DistinctPairSet.createPair(DistinctPairSet.low(c), c1Index, true));
        }
        return true;
    }

    public void splitClass(int index, int[] splitIndices) {
        TLongArrayList toAdd = new TLongArrayList();
        TLongIterator iterator = this.myData.iterator();
        while (iterator.hasNext()) {
            DistinctPair pair2 = this.decode(iterator.next());
            if (pair2.myFirst == index) {
                for (int splitIndex : splitIndices) {
                    toAdd.add(DistinctPairSet.createPair(splitIndex, pair2.mySecond, pair2.isOrdered()));
                }
                iterator.remove();
                continue;
            }
            if (pair2.mySecond != index) continue;
            for (int splitIndex : splitIndices) {
                toAdd.add(DistinctPairSet.createPair(pair2.myFirst, splitIndex, pair2.isOrdered()));
            }
            iterator.remove();
        }
        this.myData.addAll(toAdd.toNativeArray());
    }

    public boolean areDistinctUnordered(int c1Index, int c2Index) {
        return this.myData.contains(DistinctPairSet.createPair(c1Index, c2Index, false));
    }

    @Nullable
    RelationType getRelation(int c1Index, int c2Index) {
        if (this.areDistinctUnordered(c1Index, c2Index)) {
            return RelationType.NE;
        }
        if (this.myData.contains(DistinctPairSet.createPair(c1Index, c2Index, true))) {
            return RelationType.LT;
        }
        if (this.myData.contains(DistinctPairSet.createPair(c2Index, c1Index, true))) {
            return RelationType.GT;
        }
        return null;
    }

    private DistinctPair decode(long encoded) {
        boolean ordered = encoded < 0L;
        encoded = Math.abs(encoded);
        return new DistinctPair(DistinctPairSet.low(encoded), DistinctPairSet.high(encoded), ordered, this.myState.getEqClasses());
    }

    public void dropOrder(DistinctPair pair2) {
        if (this.remove(pair2)) {
            this.addUnordered(pair2.myFirst, pair2.mySecond);
        }
    }

    private static long createPair(int low, int high, boolean ordered) {
        if (ordered) {
            return -(((long)high << 32) + (long)low);
        }
        return low < high ? ((long)low << 32) + (long)high : ((long)high << 32) + (long)low;
    }

    private static int low(long l) {
        return (int)Math.abs(l);
    }

    private static int high(long l) {
        return (int)((Math.abs(l) & 0xFFFFFFFF00000000L) >> 32);
    }

    static final class DistinctPair {
        private final int myFirst;
        private final int mySecond;
        private final boolean myOrdered;
        private final List<EqClass> myList;

        private DistinctPair(int first, int second, boolean ordered, List<EqClass> list) {
            this.myFirst = first;
            this.mySecond = second;
            this.myOrdered = ordered;
            this.myList = list;
        }

        @NotNull
        public EqClass getFirst() {
            return this.myList.get(this.myFirst);
        }

        public int getFirstIndex() {
            return this.myFirst;
        }

        @NotNull
        public EqClass getSecond() {
            return this.myList.get(this.mySecond);
        }

        public int getSecondIndex() {
            return this.mySecond;
        }

        public void check() {
            if (this.myList.get(this.myFirst) == null) {
                throw new IllegalStateException(this + ": EqClass " + this.myFirst + " is missing");
            }
            if (this.myList.get(this.mySecond) == null) {
                throw new IllegalStateException(this + ": EqClass " + this.mySecond + " is missing");
            }
        }

        public boolean isOrdered() {
            return this.myOrdered;
        }

        @Nullable
        public EqClass getOtherClass(int eqClassIndex) {
            if (this.myFirst == eqClassIndex) {
                return this.getSecond();
            }
            if (this.mySecond == eqClassIndex) {
                return this.getFirst();
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DistinctPair)) {
                return false;
            }
            DistinctPair that = (DistinctPair)obj;
            if (that.myOrdered != this.myOrdered) {
                return false;
            }
            return that.getFirst().equals(this.getFirst()) && that.getSecond().equals(this.getSecond()) || !this.myOrdered && that.getSecond().equals(this.getFirst()) && that.getFirst().equals(this.getSecond());
        }

        public int hashCode() {
            return this.getFirst().hashCode() * (this.myOrdered ? 31 : 1) + this.getSecond().hashCode();
        }

        public String toString() {
            return "{" + this.myList.get(this.myFirst) + (this.myOrdered ? "<" : "!=") + this.myList.get(this.mySecond) + "}";
        }
    }
}

