/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContractValue {
    ContractValue() {
    }

    abstract DfaValue makeDfaValue(DfaValueFactory var1, DfaCallArguments var2);

    @NotNull
    DfaCondition makeCondition(DfaValueFactory factory, DfaCallArguments arguments) {
        return DfaCondition.getUnknown();
    }

    public DfaCondition fromCall(DfaValueFactory factory, PsiCallExpression call) {
        DfaCallArguments arguments = DfaCallArguments.fromCall(factory, call);
        if (arguments == null) {
            return DfaCondition.getUnknown();
        }
        return this.makeCondition(factory, arguments);
    }

    public boolean isExclusive(ContractValue other) {
        return false;
    }

    public ContractValue invert() {
        return null;
    }

    public boolean isBoundCheckingCondition() {
        return false;
    }

    public DfaCallArguments updateArguments(DfaCallArguments arguments, boolean negated) {
        return arguments;
    }

    public OptionalInt getNullCheckedArgument(boolean equalToNull) {
        return this.getArgumentComparedTo(ContractValue.nullValue(), equalToNull);
    }

    public OptionalInt getArgumentComparedTo(ContractValue value2, boolean equal) {
        return OptionalInt.empty();
    }

    @NotNull
    DfaCallArguments fixArgument(@NotNull DfaCallArguments arguments, @NotNull UnaryOperator<DfType> converter) {
        return arguments;
    }

    public String getPresentationText(PsiMethod method) {
        return this.toString();
    }

    public PsiExpression findPlace(PsiCallExpression call) {
        return null;
    }

    public static ContractValue qualifier() {
        return Qualifier.INSTANCE;
    }

    public static ContractValue argument(int index) {
        return new Argument(index);
    }

    public ContractValue specialField(@NotNull SpecialField field) {
        return new Spec(this, field);
    }

    public static ContractValue constant(Object value2, @NotNull PsiType type2) {
        return new IndependentValue((Function<? super DfaValueFactory, ? extends DfaValue>)((Function)factory -> factory.getConstant(TypeConversionUtil.computeCastTo((Object)value2, (PsiType)type2), type2)), String.valueOf(value2));
    }

    public static ContractValue booleanValue(boolean value2) {
        return value2 ? IndependentValue.TRUE : IndependentValue.FALSE;
    }

    public static ContractValue nullValue() {
        return IndependentValue.NULL;
    }

    public static ContractValue zero() {
        return IndependentValue.ZERO;
    }

    public static ContractValue condition(ContractValue left, RelationType relation, ContractValue right) {
        return new Condition(left, relation, right);
    }

    public static class Condition
    extends ContractValue {
        private final ContractValue myLeft;
        private final ContractValue myRight;
        private final RelationType myRelationType;

        Condition(ContractValue left, RelationType type2, ContractValue right) {
            this.myLeft = left;
            this.myRight = right;
            this.myRelationType = type2;
        }

        @Override
        public boolean isBoundCheckingCondition() {
            switch (this.myRelationType) {
                case LE: 
                case LT: 
                case GE: 
                case GT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isExclusive(ContractValue other) {
            if (!(other instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)other;
            if (that.myLeft.equals(this.myLeft) && that.myRight.equals(this.myRight) && that.myRelationType.getNegated() == this.myRelationType) {
                return true;
            }
            if (that.myLeft.equals(this.myRight) && that.myRight.equals(this.myLeft) && that.myRelationType.getNegated() == this.myRelationType.getFlipped()) {
                return true;
            }
            if (that.myRelationType == this.myRelationType) {
                if (that.myLeft.equals(this.myLeft) && that.myRight.isExclusive(this.myRight)) {
                    return true;
                }
                if (that.myLeft.equals(this.myRight) && that.myRight.isExclusive(this.myLeft)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public DfaCallArguments updateArguments(DfaCallArguments arguments, boolean negated) {
            ContractValue target = this.getValueComparedTo(Condition.nullValue(), negated);
            if (target != null) {
                return target.fixArgument(arguments, dfType -> dfType.meet(DfaNullability.NOT_NULL.asDfType()));
            }
            target = this.getValueComparedTo(Condition.nullValue(), !negated);
            if (target != null) {
                return target.fixArgument(arguments, dfType -> dfType.meet(DfaNullability.NULL.asDfType()));
            }
            return arguments;
        }

        @Nullable
        private ContractValue getValueComparedTo(ContractValue value2, boolean equal) {
            if (this.myRelationType == RelationType.equivalence(equal)) {
                ContractValue other;
                if (this.myLeft == value2) {
                    other = this.myRight;
                } else if (this.myRight == value2) {
                    other = this.myLeft;
                } else {
                    return null;
                }
                return other;
            }
            if (value2 == IndependentValue.FALSE) {
                return this.getValueComparedTo(IndependentValue.TRUE, !equal);
            }
            return null;
        }

        @Override
        public OptionalInt getArgumentComparedTo(ContractValue value2, boolean equal) {
            ContractValue other = this.getValueComparedTo(value2, equal);
            return other instanceof Argument ? OptionalInt.of(((Argument)other).myIndex) : OptionalInt.empty();
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return factory.getUnknown();
        }

        @Override
        @NotNull
        DfaCondition makeCondition(DfaValueFactory factory, DfaCallArguments arguments) {
            DfaValue left = this.myLeft.makeDfaValue(factory, arguments);
            DfaValue right = this.myRight.makeDfaValue(factory, arguments);
            if (left.getDfType() instanceof DfPrimitiveType) {
                right = DfaUtil.boxUnbox(right, left.getType());
            }
            if (right.getDfType() instanceof DfPrimitiveType) {
                left = DfaUtil.boxUnbox(left, right.getType());
            }
            return left.cond(this.myRelationType, right);
        }

        @Override
        public String getPresentationText(PsiMethod method) {
            if (this.myLeft instanceof IndependentValue) {
                return this.myRight.getPresentationText(method) + " " + (Object)((Object)this.myRelationType.getFlipped()) + " " + this.myLeft.getPresentationText(method);
            }
            return this.myLeft.getPresentationText(method) + " " + (Object)((Object)this.myRelationType) + " " + this.myRight.getPresentationText(method);
        }

        @NotNull
        public RelationType getRelationType() {
            return this.myRelationType;
        }

        @NotNull
        public ContractValue getLeft() {
            return this.myLeft;
        }

        @NotNull
        public ContractValue getRight() {
            return this.myRight;
        }

        @Override
        public ContractValue invert() {
            return new Condition(this.myLeft, this.myRelationType.getNegated(), this.myRight);
        }

        public String toString() {
            return this.myLeft + " " + (Object)((Object)this.myRelationType) + " " + this.myRight;
        }
    }

    private static final class Spec
    extends ContractValue {
        @NotNull
        private final ContractValue myQualifier;
        @NotNull
        private final SpecialField myField;

        Spec(@NotNull ContractValue qualifier, @NotNull SpecialField field) {
            this.myQualifier = qualifier;
            this.myField = field;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return this.myField.createValue(factory, this.myQualifier.makeDfaValue(factory, arguments));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Spec)) {
                return false;
            }
            Spec that = (Spec)obj;
            return this.myQualifier.equals(that.myQualifier) && this.myField == that.myField;
        }

        @Override
        @NotNull
        DfaCallArguments fixArgument(@NotNull DfaCallArguments arguments, @NotNull UnaryOperator<DfType> converter) {
            return this.myQualifier.fixArgument(arguments, t -> {
                if (!(t instanceof DfReferenceType)) {
                    return t;
                }
                DfType sfType = this.myField.getFromQualifier((DfType)t);
                DfType newType = (DfType)converter.apply(sfType);
                return newType.equals(sfType) ? t : ((DfReferenceType)t).dropSpecialField().meet(this.myField.asDfType(newType));
            });
        }

        @Override
        public PsiExpression findPlace(PsiCallExpression call) {
            return this.myQualifier.findPlace(call);
        }

        @Override
        public String getPresentationText(PsiMethod method) {
            return this.myQualifier.getPresentationText(method) + "." + this.myField + (this.myField == SpecialField.ARRAY_LENGTH ? "" : "()");
        }

        public String toString() {
            return this.myQualifier + "." + this.myField + "()";
        }
    }

    private static class IndependentValue
    extends ContractValue {
        static final IndependentValue NULL = new IndependentValue((Function<? super DfaValueFactory, ? extends DfaValue>)((Function)factory -> factory.getNull()), "null");
        static final IndependentValue TRUE = new IndependentValue(factory -> factory.getBoolean(true), "true"){

            @Override
            public boolean isExclusive(ContractValue other) {
                return other == FALSE;
            }
        };
        static final IndependentValue FALSE = new IndependentValue(factory -> factory.getBoolean(false), "false"){

            @Override
            public boolean isExclusive(ContractValue other) {
                return other == TRUE;
            }
        };
        static final IndependentValue ZERO = new IndependentValue((Function<? super DfaValueFactory, ? extends DfaValue>)((Function)factory -> factory.getInt(0)), "0");
        private final Function<? super DfaValueFactory, ? extends DfaValue> mySupplier;
        private final String myPresentation;

        IndependentValue(Function<? super DfaValueFactory, ? extends DfaValue> supplier, String presentation) {
            this.mySupplier = supplier;
            this.myPresentation = presentation;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return (DfaValue)this.mySupplier.fun((Object)factory);
        }

        public String toString() {
            return this.myPresentation;
        }
    }

    private static final class Argument
    extends ContractValue {
        private final int myIndex;

        Argument(int index) {
            this.myIndex = index;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            if (arguments.myArguments.length <= this.myIndex) {
                return factory.getUnknown();
            }
            return arguments.myArguments[this.myIndex];
        }

        @Override
        public PsiExpression findPlace(PsiCallExpression call) {
            PsiExpression[] args;
            PsiExpressionList list = call.getArgumentList();
            if (list != null && (this.myIndex < (args = list.getExpressions()).length - 1 || this.myIndex == args.length - 1 && !MethodCallUtils.isVarArgCall((PsiCall)call))) {
                return args[this.myIndex];
            }
            return null;
        }

        @Override
        public String getPresentationText(PsiMethod method) {
            PsiParameter[] params = method.getParameterList().getParameters();
            if (this.myIndex == 0 && params.length == 1) {
                return JavaElementKind.PARAMETER.subject();
            }
            if (this.myIndex < params.length) {
                return params[this.myIndex].getName();
            }
            return this.toString();
        }

        @Override
        @NotNull
        DfaCallArguments fixArgument(@NotNull DfaCallArguments arguments, @NotNull UnaryOperator<DfType> converter) {
            DfType newType;
            DfType type2;
            DfaValue value2;
            if (arguments.myArguments != null && arguments.myArguments.length > this.myIndex && (value2 = arguments.myArguments[this.myIndex]) instanceof DfaTypeValue && !(type2 = value2.getDfType()).equals(newType = (DfType)converter.apply(type2))) {
                DfaValue[] clone = (DfaValue[])arguments.myArguments.clone();
                clone[this.myIndex] = value2.getFactory().fromDfType(newType);
                return new DfaCallArguments(arguments.myQualifier, clone, arguments.myMutation);
            }
            return arguments;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Argument && this.myIndex == ((Argument)obj).myIndex;
        }

        public String toString() {
            return "param" + (this.myIndex + 1);
        }
    }

    private static class Qualifier
    extends ContractValue {
        static final Qualifier INSTANCE = new Qualifier();

        private Qualifier() {
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return arguments.myQualifier;
        }

        @Override
        public PsiExpression findPlace(PsiCallExpression call) {
            if (call instanceof PsiMethodCallExpression) {
                return ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression();
            }
            return null;
        }

        @Override
        @NotNull
        DfaCallArguments fixArgument(@NotNull DfaCallArguments arguments, @NotNull UnaryOperator<DfType> converter) {
            DfType newType;
            DfType type2;
            if (arguments.myQualifier instanceof DfaTypeValue && !(type2 = arguments.myQualifier.getDfType()).equals(newType = (DfType)converter.apply(type2))) {
                return new DfaCallArguments(arguments.myQualifier.getFactory().fromDfType(newType), arguments.myArguments, arguments.myMutation);
            }
            return arguments;
        }

        public String toString() {
            return "this";
        }
    }
}

