/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.openapi.util.text.StringHash;
import java.nio.ByteBuffer;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class HMember
implements MemberDescriptor {
    private static final int CLASS_HASH_SIZE = 8;
    private static final int SIGNATURE_HASH_SIZE = 4;
    static final int HASH_SIZE = 12;
    final long myClass;
    final int myMethod;

    HMember(Member method) {
        this.myClass = StringHash.calc((String)method.internalClassName);
        this.myMethod = StringHash.murmur((String)method.methodName, (int)37) * 31 + StringHash.murmur((String)method.methodDesc, (int)41);
    }

    public HMember(byte @NotNull [] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.myClass = buffer.getLong();
        this.myMethod = buffer.getInt();
    }

    byte @NotNull [] asBytes() {
        ByteBuffer bytes = ByteBuffer.allocate(12);
        bytes.putLong(this.myClass).putInt(this.myMethod);
        return bytes.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMember that = (HMember)o;
        return that.myClass == this.myClass && that.myMethod == this.myMethod;
    }

    public int hashCode() {
        return Long.hashCode(this.myClass) * 31 + this.myMethod;
    }

    @Override
    @NotNull
    public HMember hashed() {
        return this;
    }

    public String toString() {
        return HMember.bytesToString(this.asBytes());
    }

    static String bytesToString(byte[] key2) {
        return IntStreamEx.of((byte[])key2).mapToObj(b -> String.format("%02x", b & 0xFF)).joining((CharSequence)".");
    }
}

