/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

final class ThrowsTypeBlockingMethodChecker
implements BlockingMethodChecker {
    private static final Set<String> BLOCKING_EXCEPTION_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.InterruptedException", "java.io.IOException"});

    ThrowsTypeBlockingMethodChecker() {
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        return true;
    }

    public boolean isMethodBlocking(@NotNull PsiMethod method) {
        return StreamEx.of((Object[])method.getThrowsList().getReferencedTypes()).cross(BLOCKING_EXCEPTION_TYPES).anyMatch(entry -> InheritanceUtil.isInheritor((PsiType)((PsiType)entry.getKey()), (String)((String)entry.getValue())));
    }
}

