/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;

public class RemoveRedundantTypeArgumentsUtil {
    private static final Logger LOG = Logger.getInstance(RemoveRedundantTypeArgumentsUtil.class);

    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        PsiElement replacement = PsiDiamondTypeUtil.createExplicitReplacement(psiElement);
        return replacement == null ? psiElement : psiElement.replace(replacement);
    }

    public static void removeRedundantTypeArguments(PsiElement element) {
        for (PsiNewExpression newExpression : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiNewExpression.class})) {
            PsiJavaCodeReferenceElement classReference2 = newExpression.getClassOrAnonymousClassReference();
            if (classReference2 == null || !PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, newExpression, null)) continue;
            RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)classReference2.getParameterList());
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        for (PsiMethodCallExpression call : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiMethodCallExpression.class})) {
            PsiTypeParameter[] parameters2;
            PsiMethod method;
            PsiType[] arguments = call.getTypeArguments();
            if (arguments.length == 0 || (method = call.resolveMethod()) == null || arguments.length != (parameters2 = method.getTypeParameters()).length || !PsiDiamondTypeUtil.areTypeArgumentsRedundant(arguments, (PsiExpression)call, false, method, parameters2)) continue;
            PsiMethodCallExpression expr2 = (PsiMethodCallExpression)factory.createExpressionFromText("foo()", null);
            new CommentTracker().replaceAndRestoreComments((PsiElement)call.getTypeArgumentList(), (PsiElement)expr2.getTypeArgumentList());
        }
    }
}

