/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaCodeBlockInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(RedundantLambdaCodeBlockInspection.class);
    private static final String SHORT_NAME = "CodeBlock2Expr";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                PsiExpression psiExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(body2);
                if (psiExpression != null) {
                    PsiElement parent = psiExpression.getParent();
                    PsiElement errorElement = parent instanceof PsiReturnStatement ? parent.getFirstChild() : body2.getFirstChild();
                    holder.registerProblem(errorElement, JavaAnalysisBundle.message((String)"statement.lambda.can.be.replaced.with.expression.lambda", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithExprFix()});
                }
            }
        };
    }

    public static PsiExpression isCodeBlockRedundant(PsiElement body2) {
        PsiExpression psiExpression;
        if (body2 instanceof PsiCodeBlock && (psiExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2)) != null && !RedundantLambdaCodeBlockInspection.findCommentsOutsideExpression(body2, psiExpression)) {
            if (LambdaUtil.isExpressionStatementExpression((PsiElement)psiExpression) && !LambdaUtil.isSafeLambdaBodyReplacement((PsiLambdaExpression)((PsiLambdaExpression)body2.getParent()), () -> psiExpression)) {
                return null;
            }
            return psiExpression;
        }
        return null;
    }

    private static boolean findCommentsOutsideExpression(PsiElement body2, PsiExpression psiExpression) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)body2, PsiComment.class);
        for (PsiComment comment : comments) {
            if (PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)comment, (boolean)true) || RedundantLambdaCodeBlockInspection.isSelfSuppressionComment(comment)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelfSuppressionComment(PsiComment comment) {
        String[] suppressIds;
        String suppressString = JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)comment);
        return suppressString != null && (suppressIds = suppressString.split(",")).length == 1 && SHORT_NAME.equals(suppressIds[0]);
    }

    private static class ReplaceWithExprFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithExprFix() {
        }

        @NotNull
        public String getFamilyName() {
            return JavaAnalysisBundle.message((String)"replace.with.expression.lambda", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression expression2;
            PsiElement body2;
            PsiLambdaExpression lambdaExpression;
            PsiElement element = descriptor.getPsiElement();
            if (element != null && (lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class)) != null && (body2 = lambdaExpression.getBody()) != null && (expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2)) != null) {
                body2.replace((PsiElement)expression2);
            }
        }
    }
}

