/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantCompareCallInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher COMPARE_METHODS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Integer", "compare").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "compare").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Short", "compare").parameterTypes("short", "short"), CallMatcher.staticCall("java.lang.Character", "compare").parameterTypes("char", "char"), CallMatcher.staticCall("java.lang.Byte", "compare").parameterTypes("byte", "byte"));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!COMPARE_METHODS.test(call)) {
                    return;
                }
                PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiBinaryExpression.class);
                if (binOp == null) {
                    return;
                }
                RelationType type2 = RelationType.fromElementType(binOp.getOperationTokenType());
                if (type2 == null) {
                    return;
                }
                if (ExpressionUtils.isZero(binOp.getLOperand()) ? (type2 = type2.getFlipped()) == null : !ExpressionUtils.isZero(binOp.getROperand())) {
                    return;
                }
                holder.registerProblem((PsiElement)call, InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new TextRange(0, call.getArgumentList().getStartOffsetInParent()), new LocalQuickFix[]{new InlineCompareCallFix(type2)});
            }
        };
    }

    private static class InlineCompareCallFix
    implements LocalQuickFix {
        @NotNull
        private final RelationType myRelationType;

        InlineCompareCallFix(@NotNull RelationType relationType) {
            this.myRelationType = relationType;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.redundant.compare.call.fix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return;
            }
            PsiBinaryExpression parent = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiBinaryExpression.class);
            if (parent == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)parent, ct.text(args[0], 9) + (Object)((Object)this.myRelationType) + ct.text(args[1], 9));
        }
    }
}

