/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverflowingLoopIndexInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitForStatement(PsiForStatement statement) {
                PsiStatement initialization = statement.getInitialization();
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)initialization, PsiDeclarationStatement.class);
                if (declaration2 == null) {
                    return;
                }
                PsiElement[] declaredElements = declaration2.getDeclaredElements();
                if (declaredElements.length != 1) {
                    return;
                }
                PsiLocalVariable indexVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
                if (indexVariable == null) {
                    return;
                }
                PsiType type2 = indexVariable.getType();
                if (!(type2.equals(PsiType.INT) || type2.equals(PsiType.LONG) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.BYTE) || type2.equals(PsiType.CHAR))) {
                    return;
                }
                ConditionType conditionType = OverflowingLoopIndexInspection.getConditionType(statement.getCondition(), (PsiVariable)indexVariable);
                if (conditionType == ConditionType.Unknown) {
                    return;
                }
                if (!OverflowingLoopIndexInspection.isMonotonousUpdate(statement.getUpdate(), conditionType, (PsiVariable)indexVariable)) {
                    return;
                }
                if (OverflowingLoopIndexInspection.indexUpdatedInBody(statement, indexVariable, conditionType)) {
                    return;
                }
                holder.registerProblem(statement.getFirstChild(), JavaBundle.message((String)"inspection.overflowing.loop.index.inspection.description", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        };
    }

    private static ConditionType getConditionType(@Nullable PsiExpression condition2, @NotNull PsiVariable variable) {
        PsiExpression lOperand;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition2, PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return ConditionType.Unknown;
        }
        IElementType tokenType = binaryExpression.getOperationTokenType();
        ConditionType type2 = ConditionType.Unknown;
        if (tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            type2 = ConditionType.VarGreater;
        } else if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE) {
            type2 = ConditionType.VarLower;
        }
        if (type2 != ConditionType.Unknown && !ExpressionUtils.isReferenceTo(lOperand = binaryExpression.getLOperand(), variable)) {
            type2 = ExpressionUtils.isReferenceTo(binaryExpression.getROperand(), variable) ? type2.inverted() : ConditionType.Unknown;
        }
        return type2;
    }

    private static boolean indexUpdatedInBody(PsiForStatement statement, PsiLocalVariable indexVariable, ConditionType conditionType) {
        PsiStatement body2 = statement.getBody();
        if (body2 == null) {
            return true;
        }
        return !((StreamEx)StreamEx.ofTree((Object)body2, element -> StreamEx.of((Object[])element.getChildren())).select(PsiReferenceExpression.class).filter(expression2 -> expression2.isReferenceTo((PsiElement)indexVariable))).allMatch(expression2 -> {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiUnaryExpression || parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getRExpression() != expression2) {
                return OverflowingLoopIndexInspection.notChangesMonotony(conditionType, (PsiVariable)indexVariable, (PsiExpression)ObjectUtils.tryCast((Object)parent, PsiExpression.class));
            }
            return true;
        });
    }

    private static boolean isMonotonousUpdate(@Nullable PsiStatement statement, ConditionType conditionType, PsiVariable variable) {
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statement, PsiExpressionStatement.class);
        if (expressionStatement == null) {
            return false;
        }
        PsiExpression expression2 = expressionStatement.getExpression();
        return OverflowingLoopIndexInspection.notChangesMonotony(conditionType, variable, expression2);
    }

    private static boolean notChangesMonotony(ConditionType conditionType, PsiVariable variable, @Nullable PsiExpression expression2) {
        PsiUnaryExpression updateUnary = (PsiUnaryExpression)ObjectUtils.tryCast((Object)expression2, PsiUnaryExpression.class);
        if (updateUnary != null) {
            IElementType tokenType = updateUnary.getOperationTokenType();
            if (!ExpressionUtils.isReferenceTo(updateUnary.getOperand(), variable)) {
                return false;
            }
            if (conditionType == ConditionType.VarGreater) {
                return tokenType == JavaTokenType.PLUSPLUS;
            }
            return tokenType == JavaTokenType.MINUSMINUS;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expression2, PsiAssignmentExpression.class);
        if (assignment != null) {
            if (!ExpressionUtils.isReferenceTo(assignment.getLExpression(), variable)) {
                return false;
            }
            Object rightPart = ExpressionUtils.computeConstantExpression(assignment.getRExpression());
            Number number = (Number)ObjectUtils.tryCast((Object)rightPart, Number.class);
            if (number == null) {
                return false;
            }
            boolean negative = number.longValue() < 0L;
            IElementType op = assignment.getOperationTokenType();
            if (conditionType == ConditionType.VarGreater) {
                return op == JavaTokenType.PLUSEQ && !negative || op == JavaTokenType.MINUSEQ && negative;
            }
            return op == JavaTokenType.MINUSEQ && !negative || op == JavaTokenType.PLUSEQ && negative;
        }
        return false;
    }

    private static enum ConditionType {
        Unknown,
        VarGreater,
        VarLower;


        ConditionType inverted() {
            switch (this) {
                case VarGreater: {
                    return VarLower;
                }
                case VarLower: {
                    return VarGreater;
                }
            }
            return Unknown;
        }
    }
}

