/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObviousNullCheckInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                Object[] args = call.getArgumentList().getExpressions();
                if (!ContainerUtil.exists((Object[])args, arg -> TrackingRunner.getObviouslyNonNullExplanation(PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)) != null)) {
                    return;
                }
                NullCheckParameter nullCheckParameter = NullCheckParameter.fromCall(call);
                if (nullCheckParameter == null) {
                    return;
                }
                if (!ExpressionUtils.isVoidContext((PsiExpression)call) && !nullCheckParameter.myReturnsParameter) {
                    return;
                }
                if (args.length <= nullCheckParameter.myIndex) {
                    return;
                }
                PsiExpression nullArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[nullCheckParameter.myIndex]);
                String explanation = TrackingRunner.getObviouslyNonNullExplanation(nullArg);
                if (explanation == null) {
                    return;
                }
                if (nullCheckParameter.myNull) {
                    holder.registerProblem((PsiElement)nullArg, JavaBundle.message((String)"inspection.redundant.null.check.always.fail.message", (Object[])new Object[]{explanation}), new LocalQuickFix[0]);
                } else {
                    PsiReferenceExpression comparedToNull = ExpressionUtils.getReferenceExpressionFromNullComparison(nullArg, false);
                    Object fix = comparedToNull == null ? new RemoveNullCheckFix() : new RemoveExcessiveNullComparisonFix();
                    holder.registerProblem((PsiElement)nullArg, JavaBundle.message((String)"inspection.redundant.null.check.message", (Object[])new Object[]{explanation}), new LocalQuickFix[]{fix});
                }
            }
        };
    }

    public static class RemoveNullCheckFix
    implements LocalQuickFix {
        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.redundant.null.check.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement startElement = descriptor.getStartElement();
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiElement parent = call.getParent();
            CommentTracker ct = new CommentTracker();
            if (parent instanceof PsiExpressionStatement) {
                List expressions2 = ((StreamEx)StreamEx.of((Object[])call.getArgumentList().getExpressions()).flatCollection(SideEffectChecker::extractSideEffectExpressions).peek(ct::markUnchanged)).toList();
                PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements(expressions2, (PsiExpression)call);
                if (sideEffectStatements.length > 0) {
                    BlockUtils.addBefore((PsiStatement)parent, sideEffectStatements);
                }
                ct.deleteAndRestoreComments(parent);
            } else {
                ct.replaceAndRestoreComments((PsiElement)call, startElement);
            }
        }
    }

    public static class RemoveExcessiveNullComparisonFix
    implements LocalQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.redundant.null.check.fix.notnull.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression arg = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class);
            if (arg == null) {
                return;
            }
            PsiReferenceExpression comparedToNull = ExpressionUtils.getReferenceExpressionFromNullComparison(arg, false);
            if (comparedToNull == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)arg, (PsiElement)comparedToNull);
        }
    }

    static class NullCheckParameter {
        int myIndex;
        boolean myNull;
        boolean myReturnsParameter;

        NullCheckParameter(int index, boolean aNull, boolean returnsParameter) {
            this.myIndex = index;
            this.myNull = aNull;
            this.myReturnsParameter = returnsParameter;
        }

        @Nullable
        static NullCheckParameter fromCall(PsiMethodCallExpression call) {
            PsiMethod method = call.resolveMethod();
            if (method == null || method.isConstructor()) {
                return null;
            }
            if (!JavaMethodContractUtil.isPure(method)) {
                return null;
            }
            List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, (PsiCallExpression)call);
            if (contracts2.isEmpty() || contracts2.size() > 2) {
                return null;
            }
            MethodContract contract = contracts2.get(0);
            if (contract == null || !contract.getReturnValue().isFail()) {
                return null;
            }
            ContractValue condition2 = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions());
            if (condition2 == null) {
                return null;
            }
            boolean isNull = false;
            int nullIndex = condition2.getNullCheckedArgument(true).orElse(-1);
            if (nullIndex == -1) {
                isNull = true;
                nullIndex = condition2.getNullCheckedArgument(false).orElse(-1);
                if (nullIndex == -1) {
                    return null;
                }
            }
            boolean returnsParameter = false;
            if (contracts2.size() == 2) {
                ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
                if (returnValue instanceof ContractReturnValue.ParameterReturnValue && ((ContractReturnValue.ParameterReturnValue)returnValue).getParameterNumber() == nullIndex) {
                    returnsParameter = true;
                } else {
                    return null;
                }
            }
            return new NullCheckParameter(nullIndex, isNull, returnsParameter);
        }
    }
}

