/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeMethodReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AnonymousCanBeMethodReferenceInspection.class);
    public boolean reportNotAnnotatedInterfaces = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "Anonymous2MethodRef";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"report.when.interface.is.not.annotated.with.functional.interface", (Object[])new Object[0]), (InspectionProfileEntry)this, "reportNotAnnotatedInterfaces");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                super.visitAnonymousClass(aClass);
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, true, AnonymousCanBeMethodReferenceInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiJavaCodeReferenceElement classReference2;
                    PsiElement parent;
                    PsiCallExpression callExpression;
                    PsiMethod resolveMethod;
                    PsiMethod method = aClass.getMethods()[0];
                    PsiCodeBlock body2 = method.getBody();
                    LambdaCanBeMethodReferenceInspection.MethodReferenceCandidate methodReferenceCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression((PsiElement)body2);
                    if (methodReferenceCandidate == null) {
                        return;
                    }
                    PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])method.getParameterList().getParameters(), (PsiType)aClass.getBaseClassType(), aClass.getParent(), methodReferenceCandidate.myExpression);
                    if (candidate instanceof PsiCallExpression && (resolveMethod = (callExpression = (PsiCallExpression)candidate).resolveMethod()) != method && !AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(resolveMethod, aClass, callExpression) && (parent = aClass.getParent()) instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)parent).getClassOrAnonymousClassReference()) != null) {
                        ProblemHighlightType type2;
                        PsiElement lBrace = aClass.getLBrace();
                        LOG.assertTrue(lBrace != null);
                        TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                        if (methodReferenceCandidate.mySafeQualifier && methodReferenceCandidate.myConformsCodeStyle) {
                            type2 = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                        } else {
                            if (!isOnTheFly) {
                                return;
                            }
                            type2 = ProblemHighlightType.INFORMATION;
                        }
                        holder.registerProblem(parent, JavaBundle.message((String)"inspection.message.anonymous.ref.loc.can.be.replaced.with.method.reference", (Object[])new Object[0]), type2, rangeInElement, new LocalQuickFix[]{new ReplaceWithMethodRefFix()});
                    }
                }
            }
        };
    }

    static void replaceWithMethodReference(@NotNull Project project, String methodRefText, PsiType castType, PsiElement replacementTarget) {
        List comments = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)replacementTarget, PsiComment.class), comment -> (PsiComment)comment.copy());
        if (methodRefText != null) {
            PsiElement anchor;
            String canonicalText = castType.getCanonicalText();
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("(" + canonicalText + ")" + methodRefText, replacementTarget);
            PsiElement castExpr = replacementTarget.replace((PsiElement)psiExpression);
            if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)castExpr)) {
                PsiExpression operand2 = ((PsiTypeCastExpression)castExpr).getOperand();
                LOG.assertTrue(operand2 != null);
                castExpr = castExpr.replace((PsiElement)operand2);
            }
            if ((anchor = PsiTreeUtil.getParentOfType((PsiElement)castExpr, PsiStatement.class)) == null) {
                anchor = castExpr;
            }
            for (PsiComment comment2 : comments) {
                anchor.getParent().addBefore((PsiElement)comment2, anchor);
            }
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(castExpr);
        }
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.replace.with.method.reference", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiNewExpression) {
                PsiAnonymousClass anonymousClass = ((PsiNewExpression)element).getAnonymousClass();
                if (anonymousClass == null) {
                    return;
                }
                PsiMethod[] methods = anonymousClass.getMethods();
                if (methods.length != 1) {
                    return;
                }
                PsiParameter[] parameters2 = methods[0].getParameterList().getParameters();
                PsiClassType functionalInterfaceType = anonymousClass.getBaseClassType();
                LambdaCanBeMethodReferenceInspection.MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression((PsiElement)methods[0].getBody());
                if (methodRefCandidate == null) {
                    return;
                }
                PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])parameters2, (PsiType)functionalInterfaceType, anonymousClass.getParent(), methodRefCandidate.myExpression);
                String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)candidate, (PsiType)functionalInterfaceType, (PsiVariable[])parameters2);
                AnonymousCanBeMethodReferenceInspection.replaceWithMethodReference(project, methodRefText, (PsiType)anonymousClass.getBaseClassType(), anonymousClass.getParent());
            }
        }
    }
}

