/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AnnotateMethodFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(AnnotateMethodFix.class);
    private final String myAnnotation;
    private final String[] myAnnotationsToRemove;

    public AnnotateMethodFix(@NotNull String fqn, String ... annotationsToRemove) {
        this.myAnnotation = fqn;
        this.myAnnotationsToRemove = annotationsToRemove.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : annotationsToRemove;
        LOG.assertTrue(this.annotateSelf() || this.annotateOverriddenMethods(), (Object)"annotate method quick fix should not do nothing");
    }

    @NotNull
    public String getName() {
        return this.getFamilyName() + " " + this.getPreposition() + " '@" + ClassUtil.extractClassName((String)this.myAnnotation) + "'";
    }

    @NotNull
    protected String getPreposition() {
        return "with";
    }

    @NotNull
    public String getFamilyName() {
        if (this.annotateSelf()) {
            if (this.annotateOverriddenMethods()) {
                return JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.and.self.quickfix.family.name", (Object[])new Object[0]);
            }
            return JavaAnalysisBundle.message((String)"inspection.annotate.method.quickfix.family.name", (Object[])new Object[0]);
        }
        return JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.quickfix.family.name", (Object[])new Object[0]);
    }

    public boolean startInWriteAction() {
        return !this.annotateOverriddenMethods();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (method == null) {
            return;
        }
        ArrayList<PsiMethod> toAnnotate = new ArrayList<PsiMethod>();
        if (this.annotateSelf()) {
            toAnnotate.add(method);
        }
        if (this.annotateOverriddenMethods() && !AnnotateMethodFix.processModifiableInheritorsUnderProgress(method, psiMethod -> {
            if (AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod, (String)this.myAnnotation) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)this.myAnnotation, (int)10)) {
                toAnnotate.add((PsiMethod)psiMethod);
            }
        })) {
            return;
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        for (PsiMethod psiMethod2 : toAnnotate) {
            this.annotateMethod(psiMethod2);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)method.getContainingFile());
    }

    protected boolean annotateOverriddenMethods() {
        return false;
    }

    protected boolean annotateSelf() {
        return true;
    }

    private void annotateMethod(@NotNull PsiMethod method) {
        AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)method, PsiNameValuePair.EMPTY_ARRAY, this.myAnnotationsToRemove);
        fix.invoke(method.getProject(), method.getContainingFile(), (PsiElement)method, (PsiElement)method);
    }

    public static boolean processModifiableInheritorsUnderProgress(@NotNull PsiMethod method, @NotNull Consumer<? super PsiMethod> consumer) {
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (PsiMethod psiMethod : OverridingMethodsSearch.search((PsiMethod)method)) {
                ReadAction.run(() -> {
                    if (psiMethod.isPhysical() && !NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(psiMethod)) {
                        consumer.accept(psiMethod);
                    }
                });
            }
        }, JavaAnalysisBundle.message((String)"searching.for.overriding.methods", (Object[])new Object[0]), true, method.getProject());
    }
}

