/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaForUnwrapper
extends JavaUnwrapper {
    public JavaForUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.for", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof PsiForStatement || e instanceof PsiForeachStatement;
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        if (element instanceof PsiForStatement) {
            this.unwrapInitializer(element, context);
        }
        this.unwrapBody(element, context);
        context.delete(element);
    }

    private void unwrapInitializer(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiStatement init = ((PsiForStatement)element).getInitialization();
        context.extractFromBlockOrSingleStatement(init, element);
    }

    private void unwrapBody(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiStatement body2 = ((PsiLoopStatement)element).getBody();
        context.extractFromBlockOrSingleStatement(body2, element);
    }
}

