/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaElseUnwrapperBase;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaElseRemover
extends JavaElseUnwrapperBase {
    public JavaElseRemover() {
        super(CodeInsightBundle.message((String)"remove.else", (Object[])new Object[0]));
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return ((PsiIfStatement)e.getParent()).getElseBranch();
    }

    @Override
    protected void unwrapElseBranch(PsiStatement branch, PsiElement parent, JavaUnwrapper.Context context) throws IncorrectOperationException {
        if (branch instanceof PsiIfStatement) {
            this.deleteSelectedElseIf((PsiIfStatement)branch, context);
        } else {
            context.delete((PsiElement)branch);
        }
    }

    private void deleteSelectedElseIf(PsiIfStatement selectedBranch, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiIfStatement parentIf = (PsiIfStatement)selectedBranch.getParent();
        PsiStatement childElse = selectedBranch.getElseBranch();
        if (childElse == null) {
            context.delete((PsiElement)selectedBranch);
            return;
        }
        context.setElseBranch(parentIf, childElse);
    }
}

