/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewExpressionPostfixTemplate
extends StringBasedPostfixTemplate {
    private static final Condition<PsiElement> CONSTRUCTOR = expression2 -> {
        if (!(expression2 instanceof PsiReferenceExpression) && !(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiReferenceExpression ref = expression2 instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression2).getMethodExpression() : (PsiReferenceExpression)expression2;
        PsiExpression qualifierExpression2 = ref.getQualifierExpression();
        if (qualifierExpression2 != null) {
            return false;
        }
        JavaResolveResult result = ref.advancedResolve(true);
        PsiElement element = result.getElement();
        return element == null || element instanceof PsiClass;
    };

    protected NewExpressionPostfixTemplate() {
        super("new", "new T()", JavaPostfixTemplatesUtils.selectorAllExpressionsWithCurrentOffset(CONSTRUCTOR));
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        return element instanceof PsiMethodCallExpression ? "new $expr$" : "new $expr$($END$)";
    }

    public void expandForChooseExpression(@NotNull PsiElement expression2, @NotNull Editor editor) {
        if (!(expression2 instanceof PsiReferenceExpression)) {
            super.expandForChooseExpression(expression2, editor);
            return;
        }
        PsiReferenceExpression refExpression = (PsiReferenceExpression)expression2;
        JavaResolveResult result = refExpression.advancedResolve(true);
        PsiElement element = result.getElement();
        if (!(element instanceof PsiClass)) {
            super.expandForChooseExpression(expression2, editor);
            return;
        }
        WriteAction.run(() -> this.insertConstructorCallWithSmartBraces(expression2, editor, (PsiClass)element));
    }

    public void insertConstructorCallWithSmartBraces(@NotNull PsiElement expression2, @NotNull Editor editor, @NotNull PsiClass javaClass) {
        Document document = editor.getDocument();
        PsiFile file = expression2.getContainingFile();
        Project project = expression2.getProject();
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)editor.getProject()).createSmartPsiElementPointer((PsiElement)javaClass);
        NewExpressionPostfixTemplate.replaceExpressionTextByNewExpressionInDocument(project, expression2, document);
        if (!javaClass.isValid()) {
            javaClass = (PsiClass)pointer.getElement();
        }
        if (javaClass == null) {
            return;
        }
        JavaPsiClassReferenceElement item = JavaClassNameCompletionContributor.createClassLookupItem(javaClass, true);
        item.handleInsert(NewExpressionPostfixTemplate.createInsertionContext(editor, file, item));
    }

    @NotNull
    private static InsertionContext createInsertionContext(@NotNull Editor editor, @NotNull PsiFile file, @NotNull JavaPsiClassReferenceElement item) {
        Document document = editor.getDocument();
        OffsetMap offsetMap = new OffsetMap(document);
        InsertionContext insertionContext = new InsertionContext(offsetMap, '\u0000', new LookupElement[]{item}, file, editor, false);
        int offset = editor.getCaretModel().getOffset();
        return CompletionUtil.newContext((InsertionContext)insertionContext, (LookupElement)item, (int)offset, (int)offset);
    }

    private static void replaceExpressionTextByNewExpressionInDocument(@NotNull Project project, @NotNull PsiElement expression2, @NotNull Document document) {
        TextRange range = expression2.getTextRange();
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("new " + expression2.getText()));
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
    }
}

