/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionLookupItem
extends LookupElement
implements TypedLookupItem {
    private final PsiExpression myExpression;
    private final Icon myIcon;
    private final String myPresentableText;
    private final String myLookupString;
    private final Set<String> myAllLookupStrings;

    public ExpressionLookupItem(PsiExpression expression2) {
        this(expression2, ExpressionLookupItem.getExpressionIcon(expression2), expression2.getText(), expression2.getText());
    }

    public ExpressionLookupItem(PsiExpression expression2, @Nullable Icon icon, String presentableText, String ... lookupStrings) {
        this.myExpression = expression2;
        this.myPresentableText = presentableText;
        this.myIcon = icon;
        this.myLookupString = lookupStrings[0];
        this.myAllLookupStrings = ContainerUtil.immutableSet((Object[])lookupStrings);
    }

    @Nullable
    private static Icon getExpressionIcon(@NotNull PsiExpression expression2) {
        PsiElement element;
        if (expression2 instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)expression2).resolve()) != null) {
            return element.getIcon(0);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return PlatformIcons.METHOD_ICON;
        }
        return null;
    }

    @NotNull
    public PsiExpression getObject() {
        return this.myExpression;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myIcon);
        presentation.setItemText(this.myPresentableText);
        PsiType type2 = this.getType();
        presentation.setTypeText(type2 == null ? null : type2.getPresentableText());
    }

    public void handleInsert(@NotNull InsertionContext context) {
        context.commitDocument();
        JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)context.getFile(), context.getStartOffset(), context.getTailOffset());
    }

    @Override
    public PsiType getType() {
        return this.myExpression.getType();
    }

    public boolean equals(Object o) {
        return o instanceof ExpressionLookupItem && this.myLookupString.equals(((ExpressionLookupItem)o).myLookupString);
    }

    public int hashCode() {
        return this.myLookupString.hashCode();
    }

    @NotNull
    public String getLookupString() {
        return this.myLookupString;
    }

    public Set<String> getAllLookupStrings() {
        return this.myAllLookupStrings;
    }
}

