/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.lists;

import com.intellij.codeInsight.intention.impl.lists.AbstractChopListAction;
import com.intellij.codeInsight.intention.impl.lists.JavaListUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaChopListAction<L extends PsiElement, E extends PsiElement>
extends AbstractChopListAction<L, E> {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!(element.getContainingFile() instanceof PsiJavaFile)) {
            return false;
        }
        return super.isAvailable(project, editor, element);
    }

    @Override
    @Nullable
    PsiElement prevBreak(@NotNull PsiElement element) {
        return JavaListUtils.prevBreak(element);
    }

    @Override
    @Nullable
    PsiElement nextBreak(@NotNull PsiElement element) {
        return JavaListUtils.nextBreak(element);
    }

    @Override
    int findOffsetForBreakAfter(E element) {
        PsiJavaToken token = (PsiJavaToken)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward(element), PsiJavaToken.class);
        if (token != null && token.getTokenType() == JavaTokenType.COMMA) {
            return token.getTextRange().getEndOffset();
        }
        return element.getTextRange().getEndOffset();
    }

    @Override
    protected boolean canChop(List<E> elements) {
        return !JavaListUtils.containsEolComments(elements);
    }
}

