/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.introduceVariable.IntroduceEmptyVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceVariableIntentionAction
extends BaseRefactoringIntentionAction {
    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.introduce.variable.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (element instanceof SyntheticElement) {
            return false;
        }
        if (IntroduceVariableIntentionAction.getTypeOfUnfilledParameter(editor, element) != null) {
            return true;
        }
        PsiExpression expression2 = IntroduceVariableIntentionAction.detectExpressionStatement(element);
        if (expression2 == null) {
            return false;
        }
        PsiType expressionType = expression2.getType();
        return expressionType != null && !PsiType.VOID.equals((Object)expressionType) && !(expression2 instanceof PsiAssignmentExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiType type2 = IntroduceVariableIntentionAction.getTypeOfUnfilledParameter(editor, element);
        if (type2 != null) {
            new IntroduceEmptyVariableHandler().invoke(editor, element.getContainingFile(), type2);
            return;
        }
        PsiExpression expression2 = IntroduceVariableIntentionAction.detectExpressionStatement(element);
        if (expression2 == null) {
            return;
        }
        new IntroduceVariableHandler().invoke(project, editor, expression2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return currentFile;
    }

    private static PsiExpression detectExpressionStatement(@NotNull PsiElement element) {
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (prevSibling instanceof PsiStatement) {
            return IntroduceVariableIntentionAction.getExpression((PsiStatement)prevSibling);
        }
        while (!(element instanceof PsiExpressionStatement) && !(element instanceof PsiReturnStatement)) {
            if ((element = element.getParent()) != null && !(element instanceof PsiCodeBlock)) continue;
            return null;
        }
        return IntroduceVariableIntentionAction.getExpression((PsiStatement)element);
    }

    private static PsiExpression getExpression(PsiStatement statement) {
        if (statement instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)statement).getExpression();
        }
        if (statement instanceof PsiReturnStatement) {
            return ((PsiReturnStatement)statement).getReturnValue();
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeOfUnfilledParameter(@NotNull Editor editor, @NotNull PsiElement element) {
        if (element.getParent() instanceof PsiExpressionList && element.getParent().getParent() instanceof PsiMethodCallExpression) {
            PsiMethod method;
            PsiJavaToken rightBoundary;
            PsiJavaToken leftBoundary = (PsiJavaToken)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PsiJavaToken.class);
            PsiJavaToken psiJavaToken = rightBoundary = element instanceof PsiJavaToken ? (PsiJavaToken)element : (PsiJavaToken)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PsiJavaToken.class);
            if (leftBoundary != null && rightBoundary != null && CharArrayUtil.isEmptyOrSpaces((CharSequence)editor.getDocument().getImmutableCharSequence(), (int)leftBoundary.getTextRange().getEndOffset(), (int)rightBoundary.getTextRange().getStartOffset()) && (method = CompletionMemory.getChosenMethod((PsiCall)element.getParent().getParent())) != null) {
                List allTokens = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element.getParent(), PsiJavaToken.class);
                PsiParameterList parameterList = method.getParameterList();
                int parameterIndex = allTokens.indexOf(leftBoundary);
                if (parameterIndex >= 0 && parameterIndex < parameterList.getParametersCount()) {
                    PsiParameter parameter2 = parameterList.getParameters()[parameterIndex];
                    return parameter2.getType();
                }
            }
        }
        return null;
    }
}

