/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSwitchIntention
extends BaseElementAtCaretIntentionAction
implements LowPriorityAction {
    public static final String TEXT = "Create switch statement";

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken lBrace;
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class, (boolean)false);
        String valueToSwitch = expressionStatement.getExpression().getText();
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)new CommentTracker().replaceAndRestoreComments((PsiElement)expressionStatement, "switch (" + valueToSwitch + ") {}");
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)switchStatement);
        PsiCodeBlock body2 = switchStatement.getBody();
        PsiJavaToken psiJavaToken = lBrace = body2 == null ? null : body2.getLBrace();
        if (lBrace != null) {
            editor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class, (boolean)false);
        return expressionStatement != null && expressionStatement.getParent() instanceof PsiCodeBlock && !(expressionStatement.getExpression() instanceof PsiAssignmentExpression) && PsiTreeUtil.findChildOfType((PsiElement)expressionStatement.getExpression(), PsiErrorElement.class) == null && CreateSwitchIntention.isValidTypeForSwitch(expressionStatement.getExpression().getType(), (PsiElement)expressionStatement);
    }

    private static boolean isValidTypeForSwitch(@Nullable PsiType type2, PsiElement context) {
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type2).resolve();
            if (resolvedClass == null) {
                return false;
            }
            return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) && resolvedClass.isEnum() || PsiUtil.isLanguageLevel7OrHigher((PsiElement)context) && "java.lang.String".equals(resolvedClass.getQualifiedName());
        }
        return type2.equals(PsiType.INT) || type2.equals(PsiType.BYTE) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.CHAR);
    }

    @NotNull
    public String getFamilyName() {
        return TEXT;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }
}

