/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ChangeUIDAction
extends PsiElementBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"change.uid.action.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        Application application = ApplicationManager.getApplication();
        Random random = application.isUnitTestMode() ? new Random(42L) : new SecureRandom();
        PsiExpression newInitializer = factory.createExpressionFromText(random.nextLong() + "L", null);
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            new CommentTracker().replaceAndRestoreComments((PsiElement)initializer, (PsiElement)newInitializer);
        } else {
            field.setInitializer(newInitializer);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field == null) {
            return false;
        }
        if (!field.getType().equals(PsiType.LONG)) {
            return false;
        }
        if (field.hasModifierProperty("final")) {
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return false;
            }
            boolean initializersHasReferencesToField = Arrays.stream(aClass.getInitializers()).anyMatch(initializer -> ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)initializer)).findFirst() != null);
            if (initializersHasReferencesToField) {
                return false;
            }
        }
        return "serialVersionUID".equals(field.getName());
    }
}

