/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.PsiImplementationViewSession;
import com.intellij.codeInsight.hint.actions.ShowImplementationsAction;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ShowSiblingsAction
extends ShowImplementationsAction {
    public void performForContext(@NotNull DataContext dataContext, boolean invokedByShortcut) {
        PsiElementListCellRenderer listRenderer;
        String findUsagesTitle;
        String title;
        PsiElement element;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = PsiImplementationViewSession.getEditor((DataContext)dataContext);
        Pair pair2 = PsiImplementationViewSession.getElementAndReference((DataContext)dataContext, (Project)project, (PsiFile)file, (Editor)editor);
        PsiElement psiElement = element = pair2 != null ? (PsiElement)pair2.first : null;
        if (element == null) {
            return;
        }
        Object[] superElements = ShowSiblingsAction.findSuperElements(element);
        if (superElements.length == 0) {
            return;
        }
        boolean isMethod = superElements[0] instanceof PsiMethod;
        NavigatablePsiElement[] navigatablePsiElements = (NavigatablePsiElement[])ContainerUtil.findAllAsArray((Object[])superElements, NavigatablePsiElement.class);
        JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup((NavigatablePsiElement[])navigatablePsiElements, (String)(title = "Choose super " + (isMethod ? "method" : "class or interface")), (String)(findUsagesTitle = "Super " + (isMethod ? "methods" : "classes/interfaces")), (ListCellRenderer)(listRenderer = isMethod ? new MethodCellRenderer(false) : new PsiClassListCellRenderer()), null, objects -> this.showSiblings(invokedByShortcut, project, editor, file, editor != null, (PsiElement)objects[0]));
        if (popup != null) {
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }

    protected boolean isSearchDeep() {
        return true;
    }

    private void showSiblings(boolean invokedByShortcut, @NotNull Project project, Editor editor, PsiFile file, boolean invokedFromEditor, @NotNull PsiElement element) {
        PsiElement[] impls = PsiImplementationViewSession.getSelfAndImplementations((Editor)editor, (PsiElement)element, (ImplementationSearcher)PsiImplementationViewSession.createImplementationsSearcher((boolean)true), (boolean)false);
        String text2 = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)element);
        this.showImplementations((ImplementationViewSession)new PsiImplementationViewSession(project, element, impls, text2, editor, file != null ? file.getVirtualFile() : null, true, false), invokedFromEditor, invokedByShortcut);
    }

    protected boolean isIncludeAlwaysSelf() {
        return false;
    }

    private static PsiElement @NotNull [] findSuperElements(PsiElement element) {
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        return FindSuperElementsHelper.findSuperElements((PsiElement)parent);
    }
}

