/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.HighlightExceptionsHandler;
import com.intellij.codeInsight.highlighting.HighlightThrowsClassesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightExceptionsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        PsiElement parent;
        if (target instanceof PsiKeyword) {
            parent = target.getParent();
            if ("try".equals(target.getText()) && parent instanceof PsiTryStatement) {
                return HighlightExceptionsHandlerFactory.createHighlightTryHandler(editor, file, target, parent);
            }
            if ("catch".equals(target.getText()) && parent instanceof PsiCatchSection) {
                return HighlightExceptionsHandlerFactory.createHighlightCatchHandler(editor, file, target, parent);
            }
            if ("throws".equals(target.getText())) {
                return HighlightExceptionsHandlerFactory.createThrowsHandler(editor, file, target);
            }
        }
        if (target instanceof PsiIdentifier && (parent = target.getParent()) instanceof PsiJavaCodeReferenceElement) {
            return HighlightExceptionsHandlerFactory.createHighlightExceptionUsagesFromThrowsHandler(editor, file, target, (PsiJavaCodeReferenceElement)parent);
        }
        return null;
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createHighlightTryHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiElement parent) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiCodeBlock tryBlock = ((PsiTryStatement)parent).getTryBlock();
        if (tryBlock == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
        PsiClassType[] types = unhandled.toArray(PsiClassType.EMPTY_ARRAY);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)tryBlock, null, (Condition<? super PsiType>)Conditions.alwaysTrue());
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createHighlightExceptionUsagesFromThrowsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiJavaCodeReferenceElement parent) {
        PsiElement list = parent.getParent();
        if (!(list instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement method = list.getParent();
        if (!(method instanceof PsiMethod)) {
            return null;
        }
        if (!file.getManager().areElementsEquivalent(list, (PsiElement)((PsiMethod)method).getThrowsList())) {
            return null;
        }
        PsiCodeBlock block = ((PsiMethod)method).getBody();
        if (block == null) {
            return null;
        }
        PsiElement resolved = parent.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)file.getProject());
        PsiClassType type2 = factory.createType(parent);
        return new HighlightThrowsClassesHandler(editor, file, target, type2, (PsiElement)block, resolved);
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createHighlightCatchHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiElement parent) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiTryStatement tryStatement = ((PsiCatchSection)parent).getTryStatement();
        PsiParameter parameter2 = ((PsiCatchSection)parent).getParameter();
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (parameter2 == null || tryBlock == null) {
            return null;
        }
        PsiParameter[] parameters2 = tryStatement.getCatchBlockParameters();
        Condition filter = type2 -> {
            for (PsiParameter p : parameters2) {
                boolean isAssignable = p.getType().isAssignableFrom(type2);
                if (p == parameter2) {
                    return isAssignable;
                }
                if (!isAssignable) continue;
                return false;
            }
            return false;
        };
        Stream<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock).stream();
        if (resourceList != null) {
            unhandled = Stream.concat(unhandled, ExceptionUtil.collectUnhandledExceptions((PsiElement)resourceList, (PsiElement)resourceList).stream());
        }
        PsiClassType[] types = (PsiClassType[])unhandled.filter(arg_0 -> ((Condition)filter).value(arg_0)).toArray(PsiClassType[]::new);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)tryBlock, (PsiElement)resourceList, (Condition<? super PsiType>)filter);
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createThrowsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiElement grand = target.getParent().getParent();
        if (!(grand instanceof PsiMethod)) {
            return null;
        }
        PsiCodeBlock body2 = ((PsiMethod)grand).getBody();
        if (body2 == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)body2, (PsiElement)body2);
        PsiClassType[] types = unhandled.toArray(PsiClassType.EMPTY_ARRAY);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)body2, null, (Condition<? super PsiType>)Conditions.alwaysTrue());
    }
}

