/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithCastSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfElseExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNotInstanceofSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNotSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNullCheckSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithParenthesesSurrounder;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaExpressionSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JavaWithParenthesesSurrounder(), new JavaWithCastSurrounder(), new JavaWithNotSurrounder(), new JavaWithNotInstanceofSurrounder(), new JavaWithIfExpressionSurrounder(), new JavaWithIfElseExpressionSurrounder(), new JavaWithNullCheckSurrounder()};

    public PsiElement @NotNull [] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiExpression expr2 = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
        if (expr2 == null && ((expr2 = IntroduceVariableBase.getSelectedExpression(file.getProject(), file, startOffset, endOffset)) == null || expr2.isPhysical())) {
            return PsiElement.EMPTY_ARRAY;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.surroundwith.expression");
        return new PsiElement[]{expr2};
    }

    public Surrounder @NotNull [] getSurrounders() {
        List extensionList = JavaExpressionSurrounder.EP_NAME.getExtensionList();
        ArrayList list = new ArrayList(SURROUNDERS.length + extensionList.size());
        Collections.addAll(list, SURROUNDERS);
        list.addAll(extensionList);
        return list.toArray(Surrounder.EMPTY_ARRAY);
    }

    public boolean isExclusive() {
        return false;
    }
}

