/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GenerationInfoBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiGenerationInfo<T extends PsiMember>
extends GenerationInfoBase
implements GenerationInfo {
    private SmartPsiElementPointer<T> myMember;
    private final boolean myMergeIfExists;
    private static final Logger LOG = Logger.getInstance(PsiGenerationInfo.class);

    public PsiGenerationInfo(@NotNull T member) {
        this(member, true);
    }

    public PsiGenerationInfo(@NotNull T member, boolean mergeIfExists) {
        this.setMember(member);
        this.myMergeIfExists = mergeIfExists;
    }

    private void setMember(@NotNull T member) {
        this.myMember = SmartPointerManager.getInstance((Project)member.getProject()).createSmartPsiElementPointer(member);
    }

    public final T getPsiMember() {
        return (T)((PsiMember)this.myMember.getElement());
    }

    @Override
    public void insert(@NotNull PsiClass aClass, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        PsiMember member = (PsiMember)Objects.requireNonNull(this.getPsiMember());
        Object existingMember = member instanceof PsiField ? aClass.findFieldByName(member.getName(), false) : (member instanceof PsiMethod ? aClass.findMethodBySignature((PsiMethod)member, false) : null);
        if (existingMember == null || !existingMember.isPhysical() || !this.myMergeIfExists) {
            PsiElement newMember = GenerateMembersUtil.insert(aClass, member, anchor, before);
            member = (PsiMember)JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(newMember);
            LOG.assertTrue(member.isValid(), (Object)member);
        } else {
            PsiModifierList modifierList = member.getModifierList();
            PsiModifierList existingModifierList = existingMember.getModifierList();
            if (modifierList != null && existingModifierList != null) {
                PsiElement annoAnchor;
                PsiAnnotation[] psiAnnotations = modifierList.getAnnotations();
                Object object = annoAnchor = existingModifierList.getAnnotations().length > 0 ? existingModifierList.getAnnotations()[0] : existingModifierList.getFirstChild();
                if (psiAnnotations.length > 0) {
                    for (PsiAnnotation annotation : psiAnnotations) {
                        PsiAnnotation existingAnno = existingModifierList.findAnnotation(annotation.getQualifiedName());
                        if (existingAnno != null) {
                            annoAnchor = existingAnno.replace((PsiElement)annotation);
                            continue;
                        }
                        existingModifierList.addBefore((PsiElement)annotation, annoAnchor);
                    }
                }
            }
            if (!(member = existingMember).isValid()) {
                LOG.error("invalid member: " + member + " existing member: " + existingMember.isValid() + " self modified list: " + modifierList + " existing modified list: " + existingModifierList);
            }
        }
        this.setMember(member);
    }
}

