/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMemberWithElement;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.PsiDocCommentOwnerMemberChooserObject;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PsiElementClassMember<T extends PsiDocCommentOwner>
extends PsiDocCommentOwnerMemberChooserObject
implements ClassMemberWithElement {
    private final T myPsiMember;
    private final SmartPsiElementPointer<T> myMemberPointer;
    private PsiSubstitutor mySubstitutor;

    protected PsiElementClassMember(@NotNull T psiMember, String text2) {
        this(psiMember, PsiSubstitutor.EMPTY, text2);
    }

    protected PsiElementClassMember(@NotNull T psiMember, @NotNull PsiSubstitutor substitutor, String text2) {
        super((PsiDocCommentOwner)psiMember, text2, psiMember.getIcon(1));
        this.myPsiMember = psiMember;
        this.myMemberPointer = SmartPointerManager.createPointer(psiMember);
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public T getElement() {
        PsiDocCommentOwner actual = (PsiDocCommentOwner)this.myMemberPointer.getElement();
        return (T)(actual != null ? actual : this.myPsiMember);
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public void setSubstitutor(PsiSubstitutor substitutor) {
        this.mySubstitutor = substitutor;
    }

    public MemberChooserObject getParentNodeDelegate() {
        PsiClass psiClass = this.getContainingClass();
        String text2 = PsiFormatUtil.formatClass((PsiClass)psiClass, (int)2049);
        return new PsiDocCommentOwnerMemberChooserObject((PsiDocCommentOwner)psiClass, text2, psiClass.getIcon(0));
    }

    protected PsiClass getContainingClass() {
        return this.getElement().getContainingClass();
    }
}

