/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementsAnnotationsHandlerImpl
implements OverrideImplementsAnnotationsHandler {
    @Override
    public String[] getAnnotations(Project project) {
        List<String> annotations = OverrideImplementsAnnotationsHandlerImpl.getCoreAnnotations(project);
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        annotations.addAll(((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).getRepeatAnnotations());
        return ArrayUtilRt.toStringArray(annotations);
    }

    @Override
    public void transferToTarget(String annotation, PsiModifierListOwner source, PsiModifierListOwner target) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)source.getProject());
        String correctedAnnotation = manager.getNullables().contains(annotation) && !annotation.equals(manager.getDefaultNullable()) ? manager.getDefaultNullable() : (manager.getNotNulls().contains(annotation) && !annotation.equals(manager.getDefaultNotNull()) ? manager.getDefaultNotNull() : annotation);
        OverrideImplementsAnnotationsHandler.super.transferToTarget(correctedAnnotation, source, target);
    }

    @Override
    public String[] getAnnotations(@NotNull PsiFile file) {
        List<String> annotations = OverrideImplementsAnnotationsHandlerImpl.getCoreAnnotations(file.getProject());
        annotations.addAll(JavaCodeStyleSettings.getInstance(file).getRepeatAnnotations());
        return ArrayUtilRt.toStringArray(annotations);
    }

    @NotNull
    private static List<String> getCoreAnnotations(Project project) {
        ArrayList<String> annotations = new ArrayList<String>();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        annotations.addAll(manager.getNotNulls());
        annotations.addAll(manager.getNullables());
        annotations.add("org.jetbrains.annotations.Nls");
        return annotations;
    }
}

