/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CaseStatementsSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e.getParent() instanceof PsiCodeBlock && e.getParent().getParent() instanceof PsiSwitchStatement;
    }

    public List<TextRange> select(@NotNull PsiElement statement, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement sibling;
        PsiElement labelStatement;
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement caseStart = statement;
        PsiElement caseEnd = statement;
        if (statement instanceof PsiSwitchStatement) {
            return result;
        }
        Object object = labelStatement = statement instanceof PsiSwitchLabelStatement ? statement : null;
        if (labelStatement == null) {
            for (sibling = statement.getPrevSibling(); sibling != null && !(sibling instanceof PsiSwitchLabelStatement); sibling = sibling.getPrevSibling()) {
                if (sibling instanceof PsiWhiteSpace) continue;
                caseStart = sibling;
            }
            labelStatement = sibling;
        }
        if (labelStatement != null) {
            PsiElement nextLabel;
            while ((nextLabel = PsiTreeUtil.skipSiblingsBackward((PsiElement)labelStatement, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiSwitchLabelStatement) {
                labelStatement = nextLabel;
            }
        }
        PsiElement psiElement = sibling = statement instanceof PsiWhiteSpace ? statement.getNextSibling() : statement;
        while (sibling instanceof PsiSwitchLabelStatement) {
            sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)sibling, (Class[])new Class[]{PsiWhiteSpace.class});
        }
        while (sibling != null && !(sibling instanceof PsiSwitchLabelStatement)) {
            if (!(sibling instanceof PsiWhiteSpace) && !(sibling instanceof PsiJavaToken)) {
                caseEnd = sibling;
            }
            sibling = sibling.getNextSibling();
        }
        Document document = editor.getDocument();
        int endOffset = DocumentUtil.getLineEndOffset((int)(caseEnd.getTextOffset() + caseEnd.getTextLength()), (Document)document) + 1;
        if (!(caseStart instanceof PsiSwitchLabelStatement)) {
            result.add(new TextRange(DocumentUtil.getLineStartOffset((int)caseStart.getTextOffset(), (Document)document), endOffset));
        }
        if (labelStatement != null) {
            result.add(new TextRange(DocumentUtil.getLineStartOffset((int)labelStatement.getTextOffset(), (Document)document), endOffset));
        }
        return result;
    }
}

