/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JavaEnterInTextBlockHandler
extends EnterInStringLiteralHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int offsetInTextBlock;
        boolean isAtFirstLine;
        int offset = editor.getCaretModel().getOffset();
        PsiLiteralExpression textBlock = JavaEnterInTextBlockHandler.getTextBlockAt(file, offset);
        if (textBlock == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int textBlockOffset = textBlock.getTextOffset();
        String text2 = textBlock.getText();
        boolean bl = isAtFirstLine = !text2.substring(0, offsetInTextBlock = offset - textBlockOffset).contains("\n");
        if (!isAtFirstLine) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        Project project = textBlock.getProject();
        int secondLineStart = text2.indexOf(10);
        if (secondLineStart == -1) {
            document.insertString(offset, (CharSequence)"\n");
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)textBlock);
            text2 = textBlock.getText();
            int indent = JavaEnterInTextBlockHandler.getIndent(text2, offsetInTextBlock + 1);
            if (indent == -1) {
                return EnterHandlerDelegate.Result.Continue;
            }
            editor.getCaretModel().moveToOffset(offset + 1 + indent);
        } else {
            int indent = JavaEnterInTextBlockHandler.getIndent(text2, secondLineStart + 1);
            if (indent == -1) {
                return EnterHandlerDelegate.Result.Continue;
            }
            String newLine = '\n' + StringUtil.repeatSymbol((char)' ', (int)indent);
            document.insertString(offset, (CharSequence)newLine);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            editor.getCaretModel().moveToOffset(offset + newLine.length());
        }
        return EnterHandlerDelegate.Result.Stop;
    }

    @Contract(value="null, _ -> null")
    private static PsiLiteralExpression getTextBlockAt(PsiFile file, int offset) {
        if (!(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaToken token = (PsiJavaToken)ObjectUtils.tryCast((Object)file.findElementAt(offset), PsiJavaToken.class);
        if (token == null || token.getTokenType() != JavaTokenType.TEXT_BLOCK_LITERAL) {
            return null;
        }
        return (PsiLiteralExpression)ObjectUtils.tryCast((Object)token.getParent(), PsiLiteralExpression.class);
    }

    private static int getIndent(@NotNull String text2, int start) {
        int indent = 0;
        for (int i = start; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                indent = 0;
                continue;
            }
            if (Character.isWhitespace(c)) {
                ++indent;
                continue;
            }
            return indent;
        }
        return -1;
    }
}

