/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.codeInsight.editorActions.ReferenceTransferableData;
import com.intellij.codeInsight.editorActions.RestoreReferencesDialog;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CopyPasteReferenceProcessor<TRef extends PsiElement>
extends CopyPastePostProcessor<ReferenceTransferableData> {
    private static final Logger LOG = Logger.getInstance(CopyPasteReferenceProcessor.class);

    @NotNull
    public List<ReferenceTransferableData> collectTransferableData(PsiFile file, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 2) {
            return Collections.emptyList();
        }
        if (!(file instanceof PsiClassOwner)) {
            return Collections.emptyList();
        }
        ArrayList<ReferenceData> array = new ArrayList<ReferenceData>();
        int refOffset = 0;
        for (int j = 0; j < startOffsets.length; ++j) {
            refOffset += startOffsets[j];
            for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffsets[j], (int)endOffsets[j])) {
                this.addReferenceData(file, refOffset, element, array);
            }
            refOffset -= endOffsets[j] + 1;
        }
        if (array.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ReferenceTransferableData(array.toArray(new ReferenceData[0])));
    }

    protected abstract void addReferenceData(PsiFile var1, int var2, PsiElement var3, ArrayList<ReferenceData> var4);

    @NotNull
    public List<ReferenceTransferableData> extractTransferableData(Transferable content) {
        ReferenceTransferableData referenceData = null;
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE != 2) {
            try {
                DataFlavor flavor = ReferenceData.getDataFlavor();
                if (flavor != null) {
                    referenceData = (ReferenceTransferableData)content.getTransferData(flavor);
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        if (referenceData != null) {
            return Collections.singletonList(referenceData.clone());
        }
        return Collections.emptyList();
    }

    public void processTransferableData(Project project, Editor editor, RangeMarker bounds, int caretOffset, Ref<Boolean> indented, List<ReferenceTransferableData> values) {
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (!(file instanceof PsiClassOwner)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        assert (values.size() == 1);
        ReferenceData[] referenceData = values.get(0).getData();
        PsiElement[] refs = this.findReferencesToRestore(file, bounds, referenceData);
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 3) {
            CopyPasteReferenceProcessor.askReferencesToRestore(project, refs, referenceData);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> {
            TreeSet imported = new TreeSet();
            this.restoreReferences(referenceData, refs, imported);
            if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 1 && !imported.isEmpty()) {
                String notificationText = JavaBundle.message((String)"copy.paste.reference.notification", (Object[])new Object[]{imported.size()});
                ApplicationManager.getApplication().invokeLater(() -> CopyPasteReferenceProcessor.showHint(editor, notificationText, e -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        this.reviewImports(project, file, imported);
                    }
                }), ModalityState.NON_MODAL);
            }
        });
    }

    protected abstract void removeImports(PsiFile var1, Set<String> var2);

    private void reviewImports(Project project, PsiFile file, Set<String> importedClasses) {
        Object[] selectedElements;
        RestoreReferencesDialog dialog = new RestoreReferencesDialog(project, ArrayUtil.toObjectArray(importedClasses), false);
        dialog.setTitle(JavaBundle.message((String)"dialog.import.on.paste.title3", (Object[])new Object[0]));
        dialog.setExplanation(JavaBundle.message((String)"dialog.paste.on.import.text3", (Object[])new Object[0]));
        if (dialog.showAndGet() && (selectedElements = dialog.getSelectedElements()).length > 0) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"", null, () -> this.removeImports(file, Arrays.stream(selectedElements).map(o -> (String)o).collect(Collectors.toSet())), (PsiFile[])new PsiFile[0]);
        }
    }

    protected static void addReferenceData(PsiElement element, ArrayList<? super ReferenceData> array, int startOffset, String qClassName, @Nullable String staticMemberName) {
        TextRange range = element.getTextRange();
        array.add(new ReferenceData(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset, qClassName, staticMemberName));
    }

    protected abstract TRef @NotNull [] findReferencesToRestore(PsiFile var1, RangeMarker var2, ReferenceData[] var3);

    protected PsiElement resolveReferenceIgnoreOverriding(PsiPolyVariantReference reference) {
        ResolveResult[] results;
        PsiElement referent = reference.resolve();
        if (referent == null && (results = reference.multiResolve(true)).length > 0) {
            referent = results[0].getElement();
        }
        return referent;
    }

    protected abstract void restoreReferences(ReferenceData[] var1, TRef[] var2, Set<String> var3);

    private static void askReferencesToRestore(Project project, PsiElement @NotNull [] refs, ReferenceData[] referenceData) {
        Object refObject;
        PsiManager manager = PsiManager.getInstance((Project)project);
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        Object[] refObjects = new Object[refs.length];
        for (int i = 0; i < referenceData.length; ++i) {
            PsiElement ref = refs[i];
            if (ref == null) continue;
            LOG.assertTrue(ref.isValid());
            ReferenceData data = referenceData[i];
            PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(data.qClassName, ref.getResolveScope());
            if (refClass == null) continue;
            refObject = refClass;
            if (data.staticMemberName != null) {
                refObject = refClass.getQualifiedName() + "." + data.staticMemberName;
            }
            refObjects[i] = refObject;
            if (array.contains(refObject)) continue;
            array.add((PsiClass)refObject);
        }
        if (array.isEmpty()) {
            return;
        }
        Object[] selectedObjects = ArrayUtil.toObjectArray(array);
        Arrays.sort(selectedObjects, (o1, o2) -> CopyPasteReferenceProcessor.getFQName(o1).compareToIgnoreCase(CopyPasteReferenceProcessor.getFQName(o2)));
        RestoreReferencesDialog dialog = new RestoreReferencesDialog(project, selectedObjects);
        dialog.show();
        selectedObjects = dialog.getSelectedElements();
        for (int i = 0; i < referenceData.length; ++i) {
            PsiElement ref = refs[i];
            if (ref == null) continue;
            PsiUtilCore.ensureValid((PsiElement)ref);
            refObject = refObjects[i];
            boolean found = false;
            for (Object selected : selectedObjects) {
                if (!Comparing.equal((Object)refObject, (Object)selected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            refs[i] = null;
        }
    }

    private static void showHint(@NotNull Editor editor, @NotNull String info, HyperlinkListener hyperlinkListener) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)info, (HyperlinkListener)hyperlinkListener, null, null));
        int flags = 10;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, flags, 0, false);
    }

    private static String getFQName(Object element) {
        return element instanceof PsiClass ? ((PsiClass)element).getQualifiedName() : (String)element;
    }
}

