/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems.pass;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.problems.pass.ProjectProblemPass;
import com.intellij.codeInsight.daemon.problems.pass.ProjectProblemPassUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectProblemPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiJavaFile javaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)file, PsiJavaFile.class);
        if (javaFile == null || !ProjectProblemPassUtils.hintsEnabled()) {
            return null;
        }
        return new ProjectProblemPass(editor, javaFile);
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }
}

