/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapObjectWithOptionalOfNullableFix
extends MethodArgumentFix
implements HighPriorityAction {
    public static final ArgumentFixerActionFactory REGISTAR = new MyFixerActionFactory();

    protected WrapObjectWithOptionalOfNullableFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        super(list, i, toType, fixerActionFactory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressionCount() == 1) {
            return QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
        }
        return QuickFixBundle.message("wrap.with.optional.parameter.text", this.myIndex + 1);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file) && super.isAvailable(project, editor, file);
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new WrapObjectWithOptionalOfNullableFix((PsiExpressionList)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myArgList, (PsiFile)target), this.myIndex, this.myToType, this.myArgumentFixerActionFactory);
    }

    public static IntentionAction createFix(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        class MyFix
        extends LocalQuickFixAndIntentionActionOnPsiElement
        implements HighPriorityAction {
            final /* synthetic */ PsiType val$type;

            protected MyFix(PsiElement psiElement) {
                this.val$type = psiElement;
                super((PsiElement)element);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                return QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                startElement.replace((PsiElement)WrapObjectWithOptionalOfNullableFix.getModifiedExpression((PsiExpression)this.getStartElement()));
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                return BaseIntentionAction.canModify((PsiElement)startElement) && PsiUtil.isLanguageLevel8OrHigher((PsiElement)startElement) && WrapObjectWithOptionalOfNullableFix.areConvertible(((PsiExpression)startElement).getType(), this.val$type);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }
        }
        return new MyFix((PsiElement)expression2, type2);
    }

    private static boolean areConvertible(@Nullable PsiType exprType, @Nullable PsiType parameterType) {
        if (!(exprType != null && exprType.isValid() && parameterType instanceof PsiClassType && parameterType.isValid())) {
            return false;
        }
        PsiClassType.ClassResolveResult resolve2 = ((PsiClassType)parameterType).resolveGenerics();
        PsiClass resolvedClass = resolve2.getElement();
        if (resolvedClass == null || !"java.util.Optional".equals(resolvedClass.getQualifiedName())) {
            return false;
        }
        Collection values = resolve2.getSubstitutor().getSubstitutionMap().values();
        if (values.isEmpty()) {
            return true;
        }
        if (values.size() > 1) {
            return false;
        }
        PsiType optionalTypeParameter = (PsiType)ContainerUtil.getFirstItem(values);
        if (optionalTypeParameter == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable((PsiType)optionalTypeParameter, (PsiType)exprType);
    }

    @NotNull
    private static PsiExpression getModifiedExpression(PsiExpression expression2) {
        Project project = expression2.getProject();
        Nullability nullability = NullabilityUtil.getExpressionNullability(expression2, true);
        String methodName = nullability == Nullability.NOT_NULL ? "of" : "ofNullable";
        String newExpressionText = "java.util.Optional." + methodName + "(" + expression2.getText() + ")";
        return JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newExpressionText, (PsiElement)expression2);
    }

    public static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            return WrapObjectWithOptionalOfNullableFix.getModifiedExpression(expression2);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            return parameterType.isConvertibleFrom(exprType) || WrapObjectWithOptionalOfNullableFix.areConvertible(exprType, parameterType);
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new WrapObjectWithOptionalOfNullableFix(list, i, toType, this);
        }
    }
}

