/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceGetClassWithClassLiteralFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private String myText;

    public ReplaceGetClassWithClassLiteralFix(PsiMethodCallExpression expression2) {
        super((PsiElement)expression2);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiClass.class);
        assert (aClass != null);
        PsiExpression classLiteral = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(aClass.getName() + ".class", startElement);
        new CommentTracker().replaceAndRestoreComments(startElement, (PsiElement)classLiteral);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiClass.class);
        if (aClass == null) {
            return false;
        }
        String className2 = aClass.getName();
        if (className2 == null) {
            return false;
        }
        this.myText = "Replace with " + className2 + ".class";
        return super.isAvailable(project, file, startElement, endElement);
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"replace.get.class.with.class.literal", (Object[])new Object[0]);
    }

    public static void registerFix(PsiMethodCallExpression callExpression, HighlightInfo errorResult) {
        PsiMethod method;
        if (callExpression.getMethodExpression().getQualifierExpression() == null && (method = callExpression.resolveMethod()) != null && PsiTypesUtil.isGetClass((PsiMethod)method)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new ReplaceGetClassWithClassLiteralFix(callExpression));
        }
    }
}

