/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteElementFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myText;

    public DeleteElementFix(@NotNull PsiElement element) {
        super(element);
        this.myText = CommonQuickFixBundle.message((String)"fix.remove.title", (Object[])new Object[]{JavaElementKind.fromElement((PsiElement)element).object()});
    }

    public DeleteElementFix(@NotNull PsiElement element, @NotNull @Nls String text2) {
        super(element);
        this.myText = text2;
    }

    @Nls
    @NotNull
    public String getText() {
        return (String)ObjectUtils.notNull((Object)this.myText, (Object)this.getFamilyName());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return CommonQuickFixBundle.message((String)"fix.remove.title", (Object[])new Object[]{JavaElementKind.UNKNOWN.object()});
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        new CommentTracker().deleteAndRestoreComments(startElement);
    }

    public static final class DeleteMultiFix
    implements IntentionAction {
        @NotNull
        private final @NotNull PsiElement @NotNull [] myElements;

        public DeleteMultiFix(PsiElement ... elements) {
            this.myElements = elements;
        }

        public @IntentionName @NotNull String getText() {
            return this.getFamilyName();
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.remove.title", (Object[])new Object[]{JavaElementKind.UNKNOWN.object()});
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            for (PsiElement element : this.myElements) {
                new CommentTracker().deleteAndRestoreComments(element);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            return new DeleteMultiFix((PsiElement[])ContainerUtil.map2Array((Object[])this.myElements, PsiElement.class, e -> PsiTreeUtil.findSameElementInCopy((PsiElement)e, (PsiFile)target)));
        }
    }
}

