/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import org.jetbrains.annotations.NotNull;

public class CreateInnerClassFromNewFix
extends CreateClassFromNewFix {
    private static final Logger LOG = Logger.getInstance(CreateInnerClassFromNewFix.class);

    public CreateInnerClassFromNewFix(PsiNewExpression expr2) {
        super(expr2);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.inner.class.from.usage.text", this.getKind().getDescriptionAccusative(), varName);
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return true;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiJavaCodeReferenceElement ref = element instanceof PsiNewExpression ? ((PsiNewExpression)element).getClassOrAnonymousClassReference() : null;
        return ref != null && ref.resolve() != null;
    }

    @Override
    protected boolean rejectQualifier(PsiExpression qualifier) {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.chooseTargetClass(project, editor, this::invokeImpl);
    }

    private void invokeImpl(PsiClass targetClass) {
        PsiNewExpression newExpression = this.getNewExpression();
        PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
        assert (ref != null);
        String refName = ref.getReferenceName();
        LOG.assertTrue(refName != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)newExpression.getProject());
        PsiClass created = this.getKind().create(elementFactory, refName);
        created = (PsiClass)targetClass.add((PsiElement)created);
        PsiModifierList modifierList = created.getModifierList();
        LOG.assertTrue(modifierList != null);
        if (PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)newExpression, (boolean)true)) {
            if (targetClass.isInterface() || PsiUtil.isLocalOrAnonymousClass((PsiClass)targetClass)) {
                modifierList.setModifierProperty("packageLocal", true);
            } else {
                modifierList.setModifierProperty("private", true);
            }
        }
        if (!(created.hasModifierProperty("static") || newExpression.getQualifier() != null || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)newExpression, (boolean)true) && PsiUtil.getEnclosingStaticElement((PsiElement)newExpression, (PsiClass)targetClass) == null && !CreateInnerClassFromNewFix.isInThisOrSuperCall(newExpression))) {
            modifierList.setModifierProperty("static", true);
        }
        CreateInnerClassFromNewFix.setupGenericParameters(created, ref);
        this.setupClassFromNewExpression(created, newExpression);
    }

    private static boolean isInThisOrSuperCall(PsiNewExpression newExpression) {
        PsiExpression expression2;
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpression, PsiExpressionStatement.class);
        return expressionStatement != null && JavaPsiConstructorUtil.isConstructorCall((PsiElement)(expression2 = expressionStatement.getExpression()));
    }
}

