/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.DeclarationSearcher;
import com.intellij.openapi.application.WriteAction;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConvertReturnStatementsVisitor
implements ReturnStatementsVisitor {
    @NotNull
    private final PsiElementFactory myFactory;
    @NotNull
    private final PsiMethod myMethod;
    @NotNull
    private final DeclarationSearcher mySearcher;
    @NotNull
    private final String myDefaultValue;
    private PsiReturnStatement myLatestReturn;

    ConvertReturnStatementsVisitor(@NotNull PsiElementFactory factory, @NotNull PsiMethod method, @NotNull PsiType targetType) {
        this.myFactory = factory;
        this.myMethod = method;
        this.mySearcher = new DeclarationSearcher(method, targetType);
        this.myDefaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)targetType);
    }

    @Override
    public void visit(List<PsiReturnStatement> returnStatements) throws IncorrectOperationException {
        PsiReturnStatement statement = (PsiReturnStatement)WriteAction.compute(() -> this.replaceReturnStatements(returnStatements));
        if (statement != null) {
            this.myLatestReturn = statement;
        }
    }

    public PsiReturnStatement getLatestReturn() {
        return this.myLatestReturn;
    }

    private String generateValue(@NotNull PsiElement stopElement) {
        PsiVariable variable = this.mySearcher.getDeclaration(stopElement);
        return variable != null ? variable.getName() : this.myDefaultValue;
    }

    public PsiReturnStatement createReturnInLastStatement() throws IncorrectOperationException {
        return (PsiReturnStatement)WriteAction.compute(() -> {
            PsiCodeBlock body2 = this.myMethod.getBody();
            PsiJavaToken rBrace = body2.getRBrace();
            if (rBrace == null) {
                return null;
            }
            String value2 = this.generateValue((PsiElement)rBrace);
            PsiReturnStatement returnStatement = (PsiReturnStatement)this.myFactory.createStatementFromText("return " + value2 + ";", (PsiElement)this.myMethod);
            return (PsiReturnStatement)body2.addBefore((PsiElement)returnStatement, (PsiElement)rBrace);
        });
    }

    @Nullable
    public PsiReturnStatement replaceReturnStatements(List<? extends PsiReturnStatement> currentStatements) throws IncorrectOperationException {
        PsiReturnStatement latestReplaced = null;
        for (PsiReturnStatement psiReturnStatement : currentStatements) {
            if (psiReturnStatement.getReturnValue() != null) continue;
            String value2 = this.generateValue((PsiElement)psiReturnStatement);
            latestReplaced = (PsiReturnStatement)this.myFactory.createStatementFromText("return " + value2 + ";", psiReturnStatement.getParent());
            latestReplaced = (PsiReturnStatement)psiReturnStatement.replace((PsiElement)latestReplaced);
        }
        return latestReplaced;
    }
}

