/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ChangeClassSignatureFromUsageFix
extends BaseIntentionAction {
    private final PsiClass myClass;
    private final PsiReferenceParameterList myParameterList;

    public ChangeClassSignatureFromUsageFix(@NotNull PsiClass aClass, @NotNull PsiReferenceParameterList parameterList) {
        this.myClass = aClass;
        this.myParameterList = parameterList;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.class.signature.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myClass.isValid() || !this.myParameterList.isValid() || this.myClass instanceof PsiCompiledElement) {
            return false;
        }
        if (this.myClass.getTypeParameters().length >= this.myParameterList.getTypeArguments().length) {
            return false;
        }
        PsiTypeParameterList classTypeParameterList = this.myClass.getTypeParameterList();
        if (classTypeParameterList == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("change.class.signature.text", this.myClass.getName(), this.myParameterList.getText()));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiTypeParameterList classTypeParameterList = this.myClass.getTypeParameterList();
        if (classTypeParameterList == null) {
            return;
        }
        ChangeClassSignatureDialog dialog = new ChangeClassSignatureDialog(this.myClass, ChangeClassSignatureFromUsageFix.createTypeParameters(JavaCodeFragmentFactory.getInstance((Project)project), Arrays.asList(classTypeParameterList.getTypeParameters()), Arrays.asList(this.myParameterList.getTypeParameterElements())), false);
        dialog.show();
    }

    @NotNull
    private static List<TypeParameterInfoView> createTypeParameters(@NotNull JavaCodeFragmentFactory factory, @NotNull List<? extends PsiTypeParameter> classTypeParameters, @NotNull List<? extends PsiTypeElement> typeElements) {
        TypeParameterNameSuggester suggester = new TypeParameterNameSuggester(classTypeParameters);
        ArrayList<TypeParameterInfoView> result = new ArrayList<TypeParameterInfoView>();
        int listIndex = 0;
        for (PsiTypeElement psiTypeElement : typeElements) {
            String suggestedName;
            PsiTypeParameter typeParameter;
            if (listIndex < classTypeParameters.size() && ChangeClassSignatureFromUsageFix.isAssignable(typeParameter = classTypeParameters.get(listIndex), psiTypeElement.getType())) {
                result.add(new TypeParameterInfoView(new TypeParameterInfo.Existing(listIndex++), null, null));
                continue;
            }
            PsiType defaultType = psiTypeElement.getType();
            PsiClassType boundType = null;
            if (defaultType instanceof PsiClassType) {
                PsiClassType[] types;
                PsiReferenceList extendsList;
                suggestedName = suggester.suggest((PsiClassType)defaultType);
                PsiClass resolved = ((PsiClassType)defaultType).resolve();
                if (resolved != null && (extendsList = resolved.getExtendsList()) != null && (types = extendsList.getReferencedTypes()).length == 1) {
                    boundType = types[0];
                }
            } else {
                suggestedName = suggester.suggestUnusedName("T");
            }
            PsiTypeCodeFragment boundFragment = ChangeClassSignatureDialog.createTableCodeFragment(boundType, (PsiElement)psiTypeElement, factory, true);
            result.add(new TypeParameterInfoView(new TypeParameterInfo.New(suggestedName, defaultType, null), boundFragment, boundType == null ? factory.createTypeCodeFragment(suggestedName, (PsiElement)psiTypeElement, true) : ChangeClassSignatureDialog.createTableCodeFragment(boundType, (PsiElement)psiTypeElement, factory, false)));
        }
        return result;
    }

    private static boolean isAssignable(@NotNull PsiTypeParameter typeParameter, @NotNull PsiType type2) {
        for (PsiClassType t : typeParameter.getExtendsListTypes()) {
            if (t.isAssignableFrom(type2)) continue;
            return false;
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static class TypeParameterInfoView {
        private final TypeParameterInfo myInfo;
        private final PsiTypeCodeFragment myBoundValueFragment;
        private final PsiTypeCodeFragment myDefaultValueFragment;

        public TypeParameterInfoView(TypeParameterInfo info, PsiTypeCodeFragment boundValueFragment, PsiTypeCodeFragment defaultValueFragment) {
            this.myInfo = info;
            this.myBoundValueFragment = boundValueFragment;
            this.myDefaultValueFragment = defaultValueFragment;
        }

        public TypeParameterInfo getInfo() {
            return this.myInfo;
        }

        public PsiTypeCodeFragment getBoundValueFragment() {
            return this.myBoundValueFragment;
        }

        public PsiTypeCodeFragment getDefaultValueFragment() {
            return this.myDefaultValueFragment;
        }
    }

    private static class TypeParameterNameSuggester {
        private final Set<String> usedNames = new HashSet<String>();

        TypeParameterNameSuggester(PsiTypeParameter ... typeParameters) {
            this(Arrays.asList(typeParameters));
        }

        TypeParameterNameSuggester(@NotNull Collection<? extends PsiTypeParameter> typeParameters) {
            for (PsiTypeParameter psiTypeParameter : typeParameters) {
                this.usedNames.add(psiTypeParameter.getName());
            }
        }

        @NotNull
        private String suggestUnusedName(@NotNull String name2) {
            String unusedName = name2;
            int i = 0;
            while (!this.usedNames.add(unusedName)) {
                unusedName = name2 + ++i;
            }
            return unusedName;
        }

        @NotNull
        public String suggest(@NotNull PsiClassType type2) {
            return this.suggestUnusedName(StringUtil.toUpperCase((String)type2.getClassName().substring(0, 1)));
        }
    }
}

