/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.ui.GuiUtils;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class AddExtLibraryDependencyFix
extends OrderEntryFix {
    private final Module myCurrentModule;
    private final ExternalLibraryDescriptor myLibraryDescriptor;
    private final DependencyScope myScope;
    private final String myQualifiedClassName;

    AddExtLibraryDependencyFix(PsiReference reference, Module currentModule, ExternalLibraryDescriptor descriptor, DependencyScope scope, String qName) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myLibraryDescriptor = descriptor;
        this.myScope = scope;
        this.myQualifiedClassName = qName;
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("add.0.to.classpath", this.myLibraryDescriptor.getPresentableName());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !project.isDisposed() && !this.myCurrentModule.isDisposed();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        ModalityState modality = ModalityState.defaultModalityState();
        JavaProjectModelModificationService.getInstance(project).addDependency(this.myCurrentModule, this.myLibraryDescriptor, this.myScope).onSuccess(__ -> GuiUtils.invokeLaterIfNeeded(() -> {
            try {
                AddExtLibraryDependencyFix.importClass(this.myCurrentModule, editor, this.restoreReference(), this.myQualifiedClassName);
            }
            catch (IndexNotReadyException e) {
                Logger.getInstance(AddExtLibraryDependencyFix.class).info((Throwable)e);
            }
        }, (ModalityState)modality, ___ -> editor.isDisposed() || this.myCurrentModule.isDisposed()));
    }
}

