/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToThrowsFix
extends BaseIntentionAction {
    private final PsiElement myWrongElement;

    public AddExceptionToThrowsFix(@NotNull PsiElement wrongElement) {
        this.myWrongElement = wrongElement;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList exceptions = new ArrayList();
        PsiMethod targetMethod = this.collectExceptions(exceptions);
        if (targetMethod == null) {
            return;
        }
        THashSet unhandledExceptions = new THashSet(exceptions);
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project, targetMethod, (Set<? extends PsiClassType>)unhandledExceptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addExceptionsToThrowsList(@NotNull Project project, @NotNull PsiMethod targetMethod, @NotNull Set<? extends PsiClassType> unhandledExceptions) {
        boolean processSuperMethods;
        PsiMethod[] superMethods = AddExceptionToThrowsFix.getSuperMethods(targetMethod);
        boolean hasSuperMethodsWithoutExceptions = AddExceptionToThrowsFix.hasSuperMethodsWithoutExceptions(superMethods, unhandledExceptions);
        if (hasSuperMethodsWithoutExceptions && superMethods.length > 0) {
            int result;
            int n = result = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)QuickFixBundle.message("add.exception.to.throws.inherited.method.warning.text", targetMethod.getName()), (String)QuickFixBundle.message("method.is.inherited.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                processSuperMethods = true;
            } else {
                if (result != true) return;
                processSuperMethods = false;
            }
        } else {
            processSuperMethods = false;
        }
        ArrayList<PsiMethod> toModify = new ArrayList<PsiMethod>();
        toModify.add(targetMethod);
        if (processSuperMethods) {
            Collections.addAll(toModify, superMethods);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(toModify)) {
            return;
        }
        WriteAction.run(() -> {
            AddExceptionToThrowsFix.processMethod(project, targetMethod, unhandledExceptions);
            if (processSuperMethods) {
                for (PsiMethod superMethod : superMethods) {
                    AddExceptionToThrowsFix.processMethod(project, superMethod, unhandledExceptions);
                }
            }
        });
    }

    private static PsiMethod @NotNull [] getSuperMethods(@NotNull PsiMethod targetMethod) {
        ArrayList result = new ArrayList();
        AddExceptionToThrowsFix.collectSuperMethods(targetMethod, result);
        return result.toArray(PsiMethod.EMPTY_ARRAY);
    }

    private static void collectSuperMethods(@NotNull PsiMethod method, @NotNull List<? super PsiMethod> result) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            result.add((PsiMethod)superMethod);
            AddExceptionToThrowsFix.collectSuperMethods(superMethod, result);
        }
    }

    private static boolean hasSuperMethodsWithoutExceptions(PsiMethod @NotNull [] superMethods, @NotNull Set<? extends PsiClassType> unhandledExceptions) {
        for (PsiMethod superMethod : superMethods) {
            PsiClassType[] referencedTypes = superMethod.getThrowsList().getReferencedTypes();
            HashSet<? extends PsiClassType> exceptions = new HashSet<PsiClassType>(unhandledExceptions);
            for (PsiClassType referencedType : referencedTypes) {
                for (PsiClassType psiClassType : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)psiClassType)) continue;
                    exceptions.remove(psiClassType);
                }
            }
            if (exceptions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void processMethod(@NotNull Project project, @NotNull PsiMethod targetMethod, @NotNull Set<? extends PsiClassType> unhandledExceptions) throws IncorrectOperationException {
        for (PsiClassType psiClassType : unhandledExceptions) {
            PsiClass exceptionClass = psiClassType.resolve();
            if (exceptionClass == null) continue;
            PsiUtil.addException((PsiMethod)targetMethod, (PsiClass)exceptionClass);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)targetMethod.getThrowsList());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!this.myWrongElement.isValid()) {
            return false;
        }
        ArrayList unhandled = new ArrayList();
        if (this.collectExceptions(unhandled) == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.exception.to.throws.text", unhandled.size()));
        return true;
    }

    @Nullable
    private PsiMethod collectExceptions(List<? super PsiClassType> unhandled) {
        PsiElement psiElement;
        PsiElement targetElement = null;
        PsiMethod targetMethod = null;
        if (this.myWrongElement instanceof PsiMethodReferenceExpression) {
            psiElement = this.myWrongElement;
        } else {
            PsiElement[] declaredElements;
            PsiElement parentStatement = RefactoringUtil.getParentStatement(this.myWrongElement, false);
            if (parentStatement instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)parentStatement).getDeclaredElements()).length > 0 && declaredElements[0] instanceof PsiClass) {
                return null;
            }
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMethod.class});
        }
        if (psiElement instanceof PsiFunctionalExpression) {
            targetMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)psiElement);
            targetElement = psiElement instanceof PsiLambdaExpression ? ((PsiLambdaExpression)psiElement).getBody() : psiElement;
        } else if (psiElement instanceof PsiMethod) {
            targetMethod = (PsiMethod)psiElement;
            targetElement = psiElement;
        }
        if (targetElement == null || targetMethod == null || !targetMethod.getThrowsList().isPhysical()) {
            return null;
        }
        if (!ExceptionUtil.canDeclareThrownExceptions(targetMethod)) {
            return null;
        }
        List<PsiClassType> exceptions = AddExceptionToThrowsFix.getUnhandledExceptions(this.myWrongElement, targetElement, targetMethod);
        if (exceptions == null || exceptions.isEmpty()) {
            return null;
        }
        unhandled.addAll(exceptions);
        return targetMethod;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.exception.to.throws.family", new Object[0]);
    }

    @Nullable
    private static List<PsiClassType> getUnhandledExceptions(@Nullable PsiElement element, PsiElement topElement, PsiMethod targetMethod) {
        if (element == null || element == topElement && !(topElement instanceof PsiMethodReferenceExpression)) {
            return null;
        }
        List<PsiClassType> unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element);
        if (!AddExceptionToThrowsFix.filterInProjectExceptions(targetMethod, unhandledExceptions).isEmpty()) {
            return unhandledExceptions;
        }
        if (topElement instanceof PsiMethodReferenceExpression) {
            return null;
        }
        return AddExceptionToThrowsFix.getUnhandledExceptions(element.getParent(), topElement, targetMethod);
    }

    @NotNull
    private static Set<PsiClassType> filterInProjectExceptions(@Nullable PsiMethod targetMethod, @NotNull List<? extends PsiClassType> unhandledExceptions) {
        if (targetMethod == null) {
            return Collections.emptySet();
        }
        HashSet<PsiClassType> result = new HashSet<PsiClassType>();
        if (AddExceptionToThrowsFix.canModify((PsiElement)targetMethod)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = targetMethod.findSuperMethods()) {
                Set<PsiClassType> classTypes = AddExceptionToThrowsFix.filterInProjectExceptions(superMethod, unhandledExceptions);
                result.addAll(classTypes);
            }
            if (superMethods.length == 0) {
                result.addAll(unhandledExceptions);
            }
        } else {
            PsiClassType[] referencedTypes;
            for (PsiClassType referencedType : referencedTypes = targetMethod.getThrowsList().getReferencedTypes()) {
                PsiClass psiClass = referencedType.resolve();
                if (psiClass == null) continue;
                for (PsiClassType psiClassType : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)psiClassType)) continue;
                    result.add(psiClassType);
                }
            }
        }
        return result;
    }
}

