/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightClassUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    static HighlightInfo checkAbstractInstantiation(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent = ref.getParent();
        HighlightInfo highlightInfo = null;
        if (parent instanceof PsiAnonymousClass && parent.getParent() instanceof PsiNewExpression && !PsiUtilCore.hasErrorElementChild((PsiElement)parent.getParent())) {
            PsiAnonymousClass aClass = (PsiAnonymousClass)parent;
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods((PsiClass)aClass, ref.getTextRange());
        }
        return highlightInfo;
    }

    private static HighlightInfo checkClassWithAbstractMethods(@NotNull PsiClass aClass, @NotNull TextRange range) {
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, (PsiElement)aClass, range);
    }

    static HighlightInfo checkClassWithAbstractMethods(@NotNull PsiClass aClass, @NotNull PsiElement implementsFixElement, @NotNull TextRange range) {
        String referenceName;
        String messageKey;
        PsiMethod abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
        if (abstractMethod == null) {
            return null;
        }
        PsiClass superClass = abstractMethod.getContainingClass();
        if (superClass == null) {
            return null;
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            messageKey = "enum.constant.must.implement.method";
            PsiEnumConstantInitializer enumConstant = (PsiEnumConstantInitializer)aClass;
            referenceName = enumConstant.getEnumConstant().getName();
        } else if (aClass.isRecord() || implementsFixElement instanceof PsiEnumConstant) {
            messageKey = "class.must.implement.method";
            referenceName = HighlightUtil.formatClass(aClass, false);
        } else {
            messageKey = "class.must.be.abstract";
            referenceName = HighlightUtil.formatClass(aClass, false);
        }
        String message2 = JavaErrorBundle.message(messageKey, referenceName, JavaHighlightUtil.formatMethod(abstractMethod), HighlightUtil.formatClass(superClass, false));
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        PsiMethod anyMethodToImplement = ClassUtil.getAnyMethodToImplement((PsiClass)aClass);
        if (anyMethodToImplement != null) {
            if (!anyMethodToImplement.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(implementsFixElement));
            } else {
                QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)anyMethodToImplement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PROTECTED, (boolean)true)));
                QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)anyMethodToImplement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PUBLIC, (boolean)true)));
            }
        }
        if (!(aClass instanceof PsiAnonymousClass) && !aClass.isEnum() && aClass.getModifierList() != null && HighlightUtil.getIncompatibleModifier("abstract", aClass.getModifierList()) == null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false));
        }
        return errorResult;
    }

    static HighlightInfo checkClassMustBeAbstract(@NotNull PsiClass aClass, @NotNull TextRange textRange) {
        if (aClass.isEnum() ? HighlightClassUtil.hasEnumConstantsWithInitializer(aClass) : aClass.hasModifierProperty("abstract") || aClass.getRBrace() == null) {
            return null;
        }
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, textRange);
    }

    static HighlightInfo checkInstantiationOfAbstractClass(@NotNull PsiClass aClass, @NotNull PsiElement highlightElement) {
        HighlightInfo errorResult = null;
        if (!(!aClass.hasModifierProperty("abstract") || highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getType() instanceof PsiArrayType)) {
            String baseClassName = aClass.getName();
            String message2 = JavaErrorBundle.message("abstract.cannot.be.instantiated", baseClassName);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(highlightElement).descriptionAndTooltip(message2).create();
            PsiMethod anyAbstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
            if (!aClass.isInterface() && anyAbstractMethod == null) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)aClass, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.ABSTRACT, (boolean)false)));
            }
            if (anyAbstractMethod != null && highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getClassReference() != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createImplementAbstractClassMethodsFix(highlightElement));
            }
        }
        return errorResult;
    }

    static boolean hasEnumConstantsWithInitializer(@NotNull PsiClass aClass) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            PsiField[] fields;
            for (PsiField field : fields = aClass.getFields()) {
                if (!(field instanceof PsiEnumConstant) || ((PsiEnumConstant)field).getInitializingClass() == null) continue;
                return new CachedValueProvider.Result((Object)true, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return new CachedValueProvider.Result((Object)false, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    static HighlightInfo checkDuplicateTopLevelClass(@NotNull PsiClass aClass) {
        if (!(aClass.getParent() instanceof PsiFile)) {
            return null;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        int numOfClassesToFind = 2;
        if (qualifiedName.contains("$")) {
            qualifiedName = qualifiedName.replaceAll("\\$", ".");
            numOfClassesToFind = 1;
        }
        PsiManager manager = aClass.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module == null) {
            return null;
        }
        PsiClass[] classes2 = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClasses(qualifiedName, GlobalSearchScope.moduleScope((Module)module).intersectWith(aClass.getResolveScope()));
        if (classes2.length < numOfClassesToFind) {
            return null;
        }
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
        if (virtualFile == null) {
            return null;
        }
        boolean isTestSourceRoot = fileIndex.isInTestSourceContent(virtualFile);
        String dupFileName = null;
        for (PsiClass dupClass : classes2) {
            VirtualFile file;
            if (dupClass == aClass || (file = dupClass.getContainingFile().getVirtualFile()) == null || !manager.isInProject((PsiElement)dupClass) || fileIndex.isInTestSourceContent(file) != isTestSourceRoot) continue;
            dupFileName = FileUtil.toSystemDependentName((String)file.getPath());
            break;
        }
        if (dupFileName == null) {
            return null;
        }
        String message2 = JavaErrorBundle.message("duplicate.class.in.other.file", dupFileName);
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message2).create();
    }

    static HighlightInfo checkDuplicateNestedClass(@NotNull PsiClass aClass) {
        String name2;
        PsiClass parent = aClass;
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            parent = aClass.getParent();
        }
        if ((name2 = aClass.getName()) == null) {
            return null;
        }
        boolean duplicateFound = false;
        boolean checkSiblings = true;
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiElement element;
            PsiElement psiElement = element = checkSiblings ? parent.getPrevSibling() : null;
            if (element == null && ((element = parent.getParent()) instanceof PsiMethod || element instanceof PsiClass || element instanceof PsiCodeBlock && element.getParent() instanceof PsiClassInitializer)) {
                checkSiblings = false;
            }
            parent = element;
            if (element instanceof PsiDeclarationStatement) {
                element = PsiTreeUtil.getChildOfType((PsiElement)element, PsiClass.class);
            }
            if (!(element instanceof PsiClass) || !name2.equals(((PsiClass)element).getName())) continue;
            duplicateFound = true;
            break;
        }
        if (duplicateFound) {
            String message2 = JavaErrorBundle.message("duplicate.class", name2);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkPublicClassInRightFile(@NotNull PsiClass aClass) {
        PsiFile containingFile = aClass.getContainingFile();
        if (aClass.getParent() != containingFile || !aClass.hasModifierProperty("public") || !(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile file = (PsiJavaFile)containingFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || virtualFile.getNameWithoutExtension().equals(aClass.getName())) {
            return null;
        }
        String message2 = JavaErrorBundle.message("public.class.should.be.named.after.file", aClass.getName());
        TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)aClass, range.getStartOffset(), range.getEndOffset()).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "public", false, false));
        PsiClass[] classes2 = file.getClasses();
        if (classes2.length > 1) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMoveClassToSeparateFileFix(aClass));
        }
        for (PsiClass otherClass : classes2) {
            if (otherClass.getManager().areElementsEquivalent((PsiElement)otherClass, (PsiElement)aClass) || !otherClass.hasModifierProperty("public") || !virtualFile.getNameWithoutExtension().equals(otherClass.getName())) continue;
            return errorResult;
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createRenameFileFix(aClass.getName() + ".java"));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)aClass));
        return errorResult;
    }

    static HighlightInfo checkClassRestrictedKeyword(@NotNull LanguageLevel level, @NotNull PsiIdentifier identifier) {
        String className2 = identifier.getText();
        if (HighlightClassUtil.isRestrictedIdentifier(className2, level)) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(JavaErrorBundle.message("restricted.identifier", className2)).range((PsiElement)identifier).create();
        }
        return null;
    }

    public static boolean isRestrictedIdentifier(String typeName, @NotNull LanguageLevel level) {
        return "var".equals(typeName) && HighlightingFeature.LVTI.isSufficient(level) || "yield".equals(typeName) && HighlightingFeature.SWITCH_EXPRESSION.isSufficient(level) || "record".equals(typeName) && HighlightingFeature.RECORDS.isSufficient(level) || ("sealed".equals(typeName) || "permits".equals(typeName)) && HighlightingFeature.SEALED_CLASSES.isSufficient(level);
    }

    static HighlightInfo checkClassAndPackageConflict(@NotNull PsiClass aClass) {
        String simpleName;
        PsiDirectory subDirectory;
        PsiElement directory;
        String name2 = aClass.getQualifiedName();
        if ("java.lang".equals(name2)) {
            String message2 = JavaErrorBundle.message("class.clashes.with.package", name2);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        }
        PsiElement file = aClass.getParent();
        if (file instanceof PsiJavaFile && !((PsiJavaFile)file).getPackageName().isEmpty() && (directory = file.getParent()) instanceof PsiDirectory && (subDirectory = ((PsiDirectory)directory).findSubdirectory(simpleName = aClass.getName())) != null && simpleName.equals(subDirectory.getName()) && PsiTreeUtil.findChildOfType((PsiElement)subDirectory, PsiJavaFile.class) != null) {
            String message3 = JavaErrorBundle.message("class.clashes.with.package", name2);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    private static HighlightInfo checkStaticFieldDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiField.class) == null) {
            return null;
        }
        PsiField field = (PsiField)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)field) || PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
            return null;
        }
        String message2 = JavaErrorBundle.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(field.getContainingClass(), result);
        return result;
    }

    private static void registerMakeInnerClassStatic(@Nullable PsiClass aClass, @Nullable HighlightInfo result) {
        if (aClass != null && aClass.getContainingClass() != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", true, false));
        }
    }

    private static HighlightInfo checkStaticMethodDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiMethod.class) == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            return null;
        }
        String message2 = JavaErrorBundle.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic((PsiClass)keyword.getParent().getParent().getParent(), result);
        return result;
    }

    private static HighlightInfo checkStaticInitializerDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiClassInitializer.class) == null) {
            return null;
        }
        PsiClassInitializer initializer = (PsiClassInitializer)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)initializer)) {
            return null;
        }
        String message2 = JavaErrorBundle.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)initializer, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic((PsiClass)keyword.getParent().getParent().getParent(), result);
        return result;
    }

    private static PsiElement getEnclosingStaticClass(@NotNull PsiKeyword keyword, @NotNull Class<?> parentClass) {
        return new PsiMatcherImpl((PsiElement)keyword).dot(PsiMatchers.hasText("static")).parent(PsiMatchers.hasClass(PsiModifierList.class)).parent(PsiMatchers.hasClass(parentClass)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement();
    }

    private static HighlightInfo checkStaticClassDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (new PsiMatcherImpl((PsiElement)keyword).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", true)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement() == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)keyword.getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)aClass)) {
            return null;
        }
        PsiElement context = null;
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null) {
            for (PsiElement element = modifierList.getFirstChild(); element != null; element = element.getNextSibling()) {
                if (!Objects.equals(element.getText(), "static")) continue;
                context = element;
                break;
            }
        }
        TextRange range = context != null ? context.getTextRange() : HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        String message2 = JavaErrorBundle.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        if (context != keyword) {
            QuickFixAction.registerQuickFixActions((HighlightInfo)info, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)aClass, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)false)));
        }
        PsiClass containingClass = aClass.getContainingClass();
        HighlightClassUtil.registerMakeInnerClassStatic(containingClass, info);
        return info;
    }

    static HighlightInfo checkStaticDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        HighlightInfo errorResult = HighlightClassUtil.checkStaticFieldDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticMethodDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticClassDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticInitializerDeclarationInInnerClass(keyword);
        return errorResult;
    }

    static HighlightInfo checkExtendsAllowed(@NotNull PsiReferenceList list) {
        boolean isExtends;
        PsiClass aClass;
        if (list.getParent() instanceof PsiClass && ((aClass = (PsiClass)list.getParent()).isEnum() || aClass.isRecord()) && (isExtends = list.equals(aClass.getExtendsList()))) {
            String description = JavaErrorBundle.message(aClass.isRecord() ? "record.extends" : "extends.after.enum", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix((PsiElement)list));
            return info;
        }
        return null;
    }

    static HighlightInfo checkImplementsAllowed(@NotNull PsiReferenceList list) {
        boolean isImplements;
        PsiClass aClass;
        if (list.getParent() instanceof PsiClass && (aClass = (PsiClass)list.getParent()).isInterface() && (isImplements = list.equals(aClass.getImplementsList()))) {
            String description = JavaErrorBundle.message("implements.after.interface", new Object[0]);
            HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
            PsiClassType[] referencedTypes = list.getReferencedTypes();
            if (referencedTypes.length > 0) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, referencedTypes[0]));
            }
            return result;
        }
        return null;
    }

    static HighlightInfo checkExtendsClassAndImplementsInterface(@NotNull PsiReferenceList referenceList, @NotNull JavaResolveResult resolveResult, @NotNull PsiJavaCodeReferenceElement ref) {
        PsiClass aClass = (PsiClass)referenceList.getParent();
        boolean isImplements = referenceList.equals(aClass.getImplementsList());
        boolean isInterface = aClass.isInterface();
        if (isInterface && isImplements) {
            return null;
        }
        boolean mustBeInterface = isImplements || isInterface;
        HighlightInfo errorResult = null;
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom.isInterface() != mustBeInterface) {
            String message2 = JavaErrorBundle.message(mustBeInterface ? "interface.expected" : "no.interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(message2).create();
            PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(ref);
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, type2));
        }
        return errorResult;
    }

    static HighlightInfo checkCannotInheritFromFinal(@NotNull PsiClass superClass, @NotNull PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (superClass.hasModifierProperty("final") || superClass.isEnum()) {
            String message2 = JavaErrorBundle.message("inheritance.from.final.class", superClass.getQualifiedName(), superClass.isEnum() ? "enum" : "final");
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)superClass, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)));
        }
        return errorResult;
    }

    static HighlightInfo checkAnonymousInheritFinal(@NotNull PsiNewExpression expression2) {
        PsiAnonymousClass aClass = (PsiAnonymousClass)PsiTreeUtil.getChildOfType((PsiElement)expression2, PsiAnonymousClass.class);
        if (aClass == null) {
            return null;
        }
        PsiClassType baseClassReference = aClass.getBaseClassType();
        PsiClass baseClass = baseClassReference.resolve();
        if (baseClass == null) {
            return null;
        }
        return HighlightClassUtil.checkCannotInheritFromFinal(baseClass, (PsiElement)aClass.getBaseClassReference());
    }

    private static String checkDefaultConstructorThrowsException(@NotNull PsiMethod constructor, PsiClassType @NotNull [] handledExceptions) {
        PsiClassType[] referencedTypes = constructor.getThrowsList().getReferencedTypes();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        for (PsiClassType referencedType : referencedTypes) {
            if (ExceptionUtil.isUncheckedException(referencedType) || ExceptionUtil.isHandledBy(referencedType, handledExceptions)) continue;
            exceptions.add(referencedType);
        }
        if (!exceptions.isEmpty()) {
            return HighlightUtil.getUnhandledExceptionsDescriptor(exceptions);
        }
        return null;
    }

    static HighlightInfo checkClassDoesNotCallSuperConstructorOrHandleExceptions(@NotNull PsiClass aClass, @Nullable RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        if (aClass.isEnum()) {
            return null;
        }
        if (aClass.getConstructors().length != 0) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, PsiClassType.EMPTY_ARRAY);
    }

    static HighlightInfo checkBaseClassDefaultConstructorProblem(@NotNull PsiClass aClass, @Nullable RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper, @NotNull TextRange range, PsiClassType @NotNull [] handledExceptions) {
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass == null) {
            return null;
        }
        PsiMethod[] constructors = baseClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)aClass, aClass.getProject(), baseClass);
        List constructorCandidates = (resolved != null ? Collections.singletonList((PsiMethod)resolved) : Arrays.asList(constructors)).stream().filter(constructor -> {
            PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
            return (parameters2.length == 0 || parameters2.length == 1 && parameters2[0].isVarArgs()) && resolveHelper.isAccessible((PsiMember)constructor, (PsiElement)aClass, null);
        }).limit(2L).collect(Collectors.toList());
        if (constructorCandidates.size() >= 2) {
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)constructorCandidates.get(0)), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)constructorCandidates.get(1)), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(JavaErrorBundle.message("ambiguous.method.call", m1, m2)).create();
        }
        if (!constructorCandidates.isEmpty()) {
            PsiMethod constructor2 = (PsiMethod)constructorCandidates.get(0);
            String description = HighlightClassUtil.checkDefaultConstructorThrowsException(constructor2, handledExceptions);
            if (description != null) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
                return info;
            }
            if (refCountHolder != null) {
                refCountHolder.registerLocallyReferenced((PsiNamedElement)constructor2);
            }
            return null;
        }
        String description = JavaErrorBundle.message("no.default.constructor.available", HighlightUtil.formatClass(baseClass));
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
        return info;
    }

    static HighlightInfo checkMustNotBeLocal(@NotNull PsiClass aClass) {
        HighlightingFeature feature;
        IElementType token;
        if (aClass.isEnum()) {
            token = JavaTokenType.ENUM_KEYWORD;
            feature = HighlightingFeature.LOCAL_ENUMS;
        } else if (aClass.isInterface()) {
            token = JavaTokenType.INTERFACE_KEYWORD;
            feature = aClass.isAnnotationType() ? null : HighlightingFeature.LOCAL_INTERFACES;
        } else {
            return null;
        }
        if (!PsiUtil.isLocalClass((PsiClass)aClass)) {
            return null;
        }
        PsiElement anchor = (PsiElement)StreamEx.iterate((Object)aClass.getFirstChild(), Objects::nonNull, PsiElement::getNextSibling).findFirst(e -> e instanceof PsiKeyword && ((PsiKeyword)e).getTokenType().equals(token)).orElseThrow(NoSuchElementException::new);
        PsiFile file = aClass.getContainingFile();
        if (feature == null) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(anchor).descriptionAndTooltip(JavaErrorBundle.message("annotation.cannot.be.local", new Object[0])).create();
        }
        return HighlightUtil.checkFeature(anchor, feature, PsiUtil.getLanguageLevel((PsiElement)file), file);
    }

    static HighlightInfo checkCyclicInheritance(@NotNull PsiClass aClass) {
        PsiClass circularClass = InheritanceUtil.getCircularClass((PsiClass)aClass);
        if (circularClass != null) {
            String description = JavaErrorBundle.message("cyclic.inheritance", HighlightUtil.formatClass(circularClass));
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkExtendsDuplicate(@NotNull PsiJavaCodeReferenceElement element, @Nullable PsiElement resolved, @NotNull PsiFile containingFile) {
        if (!(element.getParent() instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList list = (PsiReferenceList)element.getParent();
        if (!(list.getParent() instanceof PsiClass)) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)resolved;
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        int dupCount = 0;
        PsiManager manager = containingFile.getManager();
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass resolvedElement = referencedType.resolve();
            if (resolvedElement == null || !manager.areElementsEquivalent((PsiElement)resolvedElement, (PsiElement)aClass)) continue;
            ++dupCount;
        }
        if (dupCount > 1) {
            String description = JavaErrorBundle.message("duplicate.class", HighlightUtil.formatClass(aClass));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkClassAlreadyImported(@NotNull PsiClass aClass, @NotNull PsiElement elementToHighlight) {
        PsiImportStatementBase[] importStatements;
        PsiFile file = aClass.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        if (aClass.getParent() != javaFile) {
            return null;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return null;
        }
        for (PsiImportStatementBase importStatement : importStatements = importList.getAllImportStatements()) {
            PsiElement resolved;
            if (importStatement.isOnDemand() || !((resolved = importStatement.resolve()) instanceof PsiClass) || resolved.equals(aClass) || !Comparing.equal((String)aClass.getName(), (String)((PsiClass)resolved).getName(), (boolean)true)) continue;
            String description = JavaErrorBundle.message("class.already.imported", HighlightUtil.formatClass(aClass, false));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkClassExtendsOnlyOneClass(@NotNull PsiReferenceList list) {
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.isInterface() && referencedTypes.length > 1 && aClass.getExtendsList() == list) {
            String description = JavaErrorBundle.message("class.cannot.extend.multiple.classes", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkThingNotAllowedInInterface(@NotNull PsiElement element, @Nullable PsiClass aClass) {
        if (aClass == null || !aClass.isInterface()) {
            return null;
        }
        String description = JavaErrorBundle.message("not.allowed.in.interface", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
    }

    static HighlightInfo checkQualifiedNew(@NotNull PsiNewExpression expression2, @Nullable PsiType type2, @Nullable PsiClass aClass) {
        PsiExpression qualifier = expression2.getQualifier();
        if (qualifier == null) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            String description = JavaErrorBundle.message("invalid.qualified.new", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, null));
            return info;
        }
        HighlightInfo info = null;
        if (aClass != null) {
            if (aClass.hasModifierProperty("static")) {
                String description = JavaErrorBundle.message("qualified.new.of.static.class", new Object[0]);
                info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
                if (!aClass.isEnum()) {
                    QuickFixAction.registerQuickFixActions((HighlightInfo)info, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)aClass, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)false)));
                }
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, aClass));
            } else {
                PsiElement refQualifier;
                PsiJavaCodeReferenceElement reference;
                if (aClass instanceof PsiAnonymousClass) {
                    PsiClass baseClass = PsiUtil.resolveClassInType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType());
                    if (baseClass != null && baseClass.isInterface()) {
                        info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(JavaErrorBundle.message("anonymous.class.implements.interface.cannot.have.qualifier", new Object[0])).create();
                    }
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, aClass));
                }
                if (info == null && (reference = expression2.getClassOrAnonymousClassReference()) != null && (refQualifier = reference.getQualifier()) != null) {
                    info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(refQualifier).descriptionAndTooltip(JavaErrorBundle.message("qualified.class.reference.not.allowed.in.qualified.new", new Object[0])).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix(refQualifier, QuickFixBundle.message("remove.qualifier.fix", new Object[0])));
                }
            }
        }
        return info;
    }

    static HighlightInfo checkClassExtendsForeignInnerClass(final @NotNull PsiJavaCodeReferenceElement extendRef, final PsiElement resolved) {
        PsiClass containerClass;
        PsiElement parent = extendRef.getParent();
        if (!(parent instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiClass)) {
            return null;
        }
        final PsiClass aClass = (PsiClass)grand;
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner2 = ((PsiTypeParameter)aClass).getOwner();
            if (!(owner2 instanceof PsiClass)) {
                return null;
            }
            containerClass = (PsiClass)owner2;
        } else {
            containerClass = aClass;
        }
        if (aClass.getExtendsList() != parent && aClass.getImplementsList() != parent) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            String description = JavaErrorBundle.message("class.name.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
        }
        final HighlightInfo[] infos = new HighlightInfo[1];
        extendRef.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (infos[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiClass) {
                    PsiClass base = (PsiClass)resolve2;
                    PsiClass baseClass = base.getContainingClass();
                    if (baseClass != null && base.hasModifierProperty("private") && baseClass == containerClass && baseClass.getContainingClass() == null) {
                        String description = JavaErrorBundle.message("private.symbol", HighlightUtil.formatClass(base), HighlightUtil.formatClass(baseClass));
                        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
                        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)base, "public", true, false));
                        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)base, "protected", true, false));
                        infos[0] = info;
                        return;
                    }
                    if (!PsiUtil.isInnerClass((PsiClass)base)) {
                        return;
                    }
                    if (!(resolve2 != resolved || baseClass == null || PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)extendRef, (boolean)true) && !aClass.hasModifierProperty("static") || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)baseClass, (PsiElement)extendRef, psiClass -> psiClass != aClass, (boolean)true) || HighlightClassUtil.qualifiedNewCalledInConstructors(aClass))) {
                        String description = JavaErrorBundle.message("no.enclosing.instance.in.scope", HighlightUtil.formatClass(baseClass));
                        infos[0] = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
                    }
                }
            }
        });
        return infos[0];
    }

    private static boolean qualifiedNewCalledInConstructors(@NotNull PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            PsiReferenceExpression referenceExpression;
            PsiExpression qualifierExpression2;
            PsiMethodCallExpression methodCallExpression = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (methodCallExpression == null) {
                return false;
            }
            if (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)methodCallExpression) || (qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)(referenceExpression = methodCallExpression.getMethodExpression()).getQualifierExpression())) != null) continue;
            return false;
        }
        return true;
    }

    static HighlightInfo checkCreateInnerClassFromStaticContext(@NotNull PsiNewExpression expression2, @Nullable PsiType type2, @Nullable PsiClass aClass) {
        if (type2 == null || type2 instanceof PsiArrayType || type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (aClass == null) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve()) == null) {
            return null;
        }
        PsiExpression qualifier = expression2.getQualifier();
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)expression2, qualifier, aClass);
    }

    public static HighlightInfo checkCreateInnerClassFromStaticContext(@NotNull PsiElement element, @Nullable PsiExpression qualifier, @Nullable PsiClass aClass) {
        PsiElement placeToSearchEnclosingFrom;
        if (qualifier != null) {
            PsiType qType = qualifier.getType();
            placeToSearchEnclosingFrom = PsiUtil.resolveClassInType((PsiType)qType);
        } else {
            placeToSearchEnclosingFrom = element;
        }
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext(element, placeToSearchEnclosingFrom, aClass);
    }

    static HighlightInfo checkCreateInnerClassFromStaticContext(@NotNull PsiElement element, @Nullable PsiElement placeToSearchEnclosingFrom, @Nullable PsiClass aClass) {
        if (aClass == null || !PsiUtil.isInnerClass((PsiClass)aClass)) {
            return null;
        }
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null) {
            return null;
        }
        if (outerClass instanceof PsiSyntheticClass || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)placeToSearchEnclosingFrom, (boolean)true, (boolean)false)) {
            return null;
        }
        return HighlightClassUtil.reportIllegalEnclosingUsage(placeToSearchEnclosingFrom, aClass, outerClass, element);
    }

    static HighlightInfo checkSuperQualifierType(@NotNull Project project, @NotNull PsiMethodCallExpression superCall) {
        if (!JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)superCall)) {
            return null;
        }
        PsiMethod ctr = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)superCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (ctr == null) {
            return null;
        }
        PsiClass aClass = ctr.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiClass targetClass = aClass.getSuperClass();
        if (targetClass == null) {
            return null;
        }
        PsiExpression qualifier = superCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            if (PsiUtil.isInnerClass((PsiClass)targetClass)) {
                PsiClass outerClass = targetClass.getContainingClass();
                if (outerClass != null) {
                    PsiClassType outerType = JavaPsiFacade.getElementFactory((Project)project).createType(outerClass);
                    return HighlightUtil.checkAssignability((PsiType)outerType, null, qualifier, (PsiElement)qualifier);
                }
            } else {
                String description = JavaErrorBundle.message("not.inner.class", HighlightUtil.formatClass(targetClass));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    static HighlightInfo reportIllegalEnclosingUsage(PsiElement place, @Nullable PsiClass aClass, @Nullable PsiClass outerClass, @NotNull PsiElement elementToHighlight) {
        if (outerClass != null && !PsiTreeUtil.isContextAncestor((PsiElement)outerClass, (PsiElement)place, (boolean)false)) {
            String description = JavaErrorBundle.message("is.not.an.enclosing.class", HighlightUtil.formatClass(outerClass));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            HighlightClassUtil.registerMakeInnerClassStatic(aClass, highlightInfo);
            return highlightInfo;
        }
        PsiModifierListOwner staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, (PsiClass)outerClass);
        if (staticParent != null) {
            String element = outerClass == null ? "" : HighlightUtil.formatClass(outerClass) + "." + (place instanceof PsiSuperExpression ? "super" : "this");
            String description = JavaErrorBundle.message("cannot.be.referenced.from.static.context", element);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
            if (aClass != null && HighlightUtil.getIncompatibleModifier("static", aClass.getModifierList()) == null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", true, false));
            }
            return highlightInfo;
        }
        return null;
    }

    public static HighlightInfo checkWellFormedRecord(PsiClass psiClass) {
        PsiRecordHeader header = psiClass.getRecordHeader();
        if (!psiClass.isRecord()) {
            if (header != null) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)header).descriptionAndTooltip(JavaErrorBundle.message("record.header.regular.class", new Object[0])).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix((PsiElement)header));
                return info;
            }
            return null;
        }
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        if (header == null) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(JavaErrorBundle.message("record.no.header", new Object[0])).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddEmptyRecordHeaderFix(psiClass));
            return info;
        }
        return null;
    }

    public static HighlightInfo checkIllegalInstanceMemberInRecord(PsiMember member) {
        PsiClass aClass;
        if (!member.hasModifierProperty("static") && (aClass = member.getContainingClass()) != null && aClass.isRecord()) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)member).descriptionAndTooltip(JavaErrorBundle.message(member instanceof PsiClassInitializer ? "record.instance.initializer" : "record.instance.field", new Object[0])).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)member, "static", true, false));
            return info;
        }
        return null;
    }

    static HighlightInfo checkExtendsProhibitedClass(@NotNull PsiClass superClass, @NotNull PsiElement elementToHighlight) {
        String qualifiedName = superClass.getQualifiedName();
        if ("java.lang.Enum".equals(qualifiedName) || "java.lang.Record".equals(qualifiedName)) {
            String message2 = JavaErrorBundle.message("classes.extends.prohibited.super", qualifiedName);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    public static HighlightInfo checkAnonymousInheritProhibited(PsiNewExpression expression2) {
        PsiAnonymousClass aClass = expression2.getAnonymousClass();
        if (aClass != null) {
            PsiClass superClass = aClass.getSuperClass();
            PsiJavaCodeReferenceElement reference = expression2.getClassOrAnonymousClassReference();
            if (superClass != null && reference != null) {
                return HighlightClassUtil.checkExtendsProhibitedClass(superClass, (PsiElement)reference);
            }
        }
        return null;
    }

    static HighlightInfo checkExtendsSealedClass(PsiClass aClass, PsiClass superClass, PsiJavaCodeReferenceElement elementToHighlight) {
        if (superClass.hasModifierProperty("sealed")) {
            if (PsiUtil.isLocalClass((PsiClass)aClass)) {
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)elementToHighlight).descriptionAndTooltip(JavaErrorBundle.message("local.classes.must.not.extend.sealed.classes", new Object[0])).create();
            }
            PsiClassType[] permittedTypes = superClass.getPermitsListTypes();
            if (permittedTypes.length > 0 ? Arrays.stream(permittedTypes).map(permittedType -> permittedType.resolve()).anyMatch(permittedClass -> aClass.equals(permittedClass)) : aClass.getContainingFile() == superClass.getContainingFile()) {
                return null;
            }
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(JavaErrorBundle.message("not.allowed.in.sealed.hierarchy", aClass.getName())).range((PsiElement)elementToHighlight).create();
        }
        return null;
    }

    public static HighlightInfo checkAnonymousSealedProhibited(PsiNewExpression newExpression) {
        PsiClass superClass;
        PsiAnonymousClass aClass = newExpression.getAnonymousClass();
        if (aClass != null && (superClass = aClass.getBaseClassType().resolve()) != null && superClass.hasModifierProperty("sealed")) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)aClass.getBaseClassReference()).descriptionAndTooltip(JavaErrorBundle.message("anonymous.classes.must.not.extend.sealed.classes", new Object[0])).create();
        }
        return null;
    }

    static void checkPermitsList(PsiReferenceList list, HighlightInfoHolder holder) {
        PsiElement parent = list.getParent();
        if (parent instanceof PsiClass && list.equals(((PsiClass)parent).getPermitsList())) {
            PsiClass aClass = (PsiClass)parent;
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            if (!aClass.hasModifierProperty("sealed")) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(list.getFirstChild()).descriptionAndTooltip(JavaErrorBundle.message("invalid.permits.clause", aClass.getName())).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "sealed", true, false));
                holder.add(info);
            }
            PsiJavaModule currentModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)aClass);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)aClass.getProject());
            for (PsiJavaCodeReferenceElement permitted : list.getReferenceElements()) {
                @Nullable PsiElement resolve2 = permitted.resolve();
                if (!(resolve2 instanceof PsiClass)) continue;
                PsiClass inheritorClass = (PsiClass)resolve2;
                if (Arrays.stream(inheritorClass.getSuperTypes()).noneMatch(type2 -> aClass.equals(type2.resolve()))) {
                    holder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)permitted).descriptionAndTooltip(JavaErrorBundle.message("invalid.permits.clause.direct.implementation", inheritorClass.getName(), inheritorClass.isInterface() == aClass.isInterface() ? 1 : 2, aClass.getName())).create());
                    continue;
                }
                if (currentModule == null && !psiFacade.arePackagesTheSame((PsiElement)aClass, (PsiElement)inheritorClass)) {
                    holder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)permitted).descriptionAndTooltip(JavaErrorBundle.message("class.not.allowed.to.extend.sealed.class.from.another.package", new Object[0])).create());
                    continue;
                }
                if (currentModule == null || currentModule == JavaModuleGraphUtil.findDescriptorByElement((PsiElement)inheritorClass)) continue;
                holder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)permitted).descriptionAndTooltip(JavaErrorBundle.message("class.not.allowed.to.extend.sealed.class.from.another.module", new Object[0])).create());
            }
        }
    }

    public static HighlightInfo checkSealedNonEnumeratedInheritors(PsiClass psiClass) {
        if (psiClass.hasModifierProperty("sealed") && psiClass.getPermitsListTypes().length == 0) {
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            if (nameIdentifier == null) {
                return null;
            }
            if (!DirectClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)new LocalSearchScope((PsiElement)psiClass.getContainingFile())).anyMatch(c -> !PsiUtil.isLocalOrAnonymousClass((PsiClass)c))) {
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameIdentifier).descriptionAndTooltip(JavaErrorBundle.message("sealed.must.have.inheritors", new Object[0])).create();
            }
        }
        return null;
    }

    public static HighlightInfo checkSealedSuper(PsiClass aClass) {
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        if (nameIdentifier != null && !aClass.hasModifierProperty("sealed") && !aClass.hasModifierProperty("non-sealed") && !aClass.hasModifierProperty("final") && Arrays.stream(aClass.getSuperTypes()).map(type2 -> type2.resolve()).anyMatch(superClass -> superClass != null && superClass.hasModifierProperty("sealed"))) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameIdentifier).descriptionAndTooltip(JavaErrorBundle.message("sealed.type.inheritor.expected.modifiers", "sealed", "non-sealed", "final")).create();
            if (!aClass.isInterface()) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "final", true, false));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "sealed", true, false));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "non-sealed", true, false));
            return info;
        }
        return null;
    }
}

