/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.icons.AllIcons;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaServiceUtil {
    static final CallMatcher SERVICE_LOADER_LOAD = CallMatcher.staticCall("java.util.ServiceLoader", "load", "loadInstalled");

    JavaServiceUtil() {
    }

    static boolean isServiceProviderMethod(@NotNull PsiMethod method) {
        return "provider".equals(method.getName()) && method.getParameterList().isEmpty() && method.hasModifierProperty("public") && method.hasModifierProperty("static");
    }

    @NotNull
    static List<LineMarkerInfo<PsiElement>> collectServiceProviderMethod(@NotNull PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        PsiClass resultClass = PsiUtil.resolveClassInType((PsiType)method.getReturnType());
        return JavaServiceUtil.createJavaServiceLineMarkerInfo(method.getNameIdentifier(), containingClass, resultClass);
    }

    @NotNull
    static List<LineMarkerInfo<PsiElement>> collectServiceImplementationClass(@NotNull PsiClass psiClass) {
        return JavaServiceUtil.createJavaServiceLineMarkerInfo(psiClass.getNameIdentifier(), psiClass, psiClass);
    }

    @NotNull
    private static List<LineMarkerInfo<PsiElement>> createJavaServiceLineMarkerInfo(@Nullable PsiIdentifier identifier, @Nullable PsiClass implementerClass, @Nullable PsiClass resultClass) {
        PsiJavaModule javaModule;
        String implementerClassName;
        if (identifier != null && implementerClass != null && resultClass != null && (implementerClassName = implementerClass.getQualifiedName()) != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)identifier) && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)identifier)) != null) {
            for (PsiProvidesStatement providesStatement : javaModule.getProvides()) {
                PsiClassType[] implementationTypes;
                PsiClassType interfaceType = providesStatement.getInterfaceType();
                PsiReferenceList implementationList = providesStatement.getImplementationList();
                if (interfaceType == null || implementationList == null) continue;
                for (PsiClassType implementationType : implementationTypes = implementationList.getReferencedTypes()) {
                    String interfaceClassName;
                    PsiClass interfaceClass;
                    if (!implementerClass.equals(implementationType.resolve()) || !InheritanceUtil.isInheritorOrSelf((PsiClass)resultClass, (PsiClass)(interfaceClass = interfaceType.resolve()), (boolean)true) || (interfaceClassName = interfaceClass.getQualifiedName()) == null) continue;
                    LineMarkerInfo info = new LineMarkerInfo((PsiElement)identifier, identifier.getTextRange(), AllIcons.Gutter.Java9Service, e -> JavaAnalysisBundle.message((String)"service.provides", (Object[])new Object[]{interfaceClassName}), (GutterIconNavigationHandler)new ServiceProvidesNavigationHandler(interfaceClassName, implementerClassName), GutterIconRenderer.Alignment.LEFT);
                    return Collections.singletonList(info);
                }
            }
        }
        return Collections.emptyList();
    }

    static List<LineMarkerInfo<PsiElement>> collectServiceLoaderLoadCall(@NotNull PsiIdentifier identifier, @NotNull PsiMethodCallExpression methodCall) {
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)methodCall)) {
            PsiJavaModule javaModule;
            String qualifiedName;
            PsiClass psiClass;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            JavaReflectionReferenceUtil.ReflectiveType serviceType = null;
            for (int i = 0; i < arguments.length && serviceType == null; ++i) {
                serviceType = JavaReflectionReferenceUtil.getReflectiveType(arguments[i]);
            }
            if (serviceType != null && serviceType.isExact() && (psiClass = serviceType.getPsiClass()) != null && (qualifiedName = psiClass.getQualifiedName()) != null && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)methodCall)) != null) {
                for (PsiUsesStatement statement : javaModule.getUses()) {
                    PsiClassType usedClass = statement.getClassType();
                    if (usedClass == null || !psiClass.equals(usedClass.resolve())) continue;
                    LineMarkerInfo info = new LineMarkerInfo((PsiElement)identifier, identifier.getTextRange(), AllIcons.Gutter.Java9Service, e -> JavaAnalysisBundle.message((String)"service.uses", (Object[])new Object[]{qualifiedName}), (GutterIconNavigationHandler)new ServiceUsesNavigationHandler(qualifiedName), GutterIconRenderer.Alignment.LEFT);
                    return Collections.singletonList(info);
                }
            }
        }
        return Collections.emptyList();
    }

    private static class ServiceProvidesNavigationHandler
    extends ServiceNavigationHandler {
        private final String myImplementerClassName;

        ServiceProvidesNavigationHandler(@NotNull String interfaceClassName, @NotNull String implementerClassName) {
            super(interfaceClassName);
            this.myImplementerClassName = implementerClassName;
        }

        @Override
        public PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule module) {
            PsiReferenceList list;
            PsiProvidesStatement statement = (PsiProvidesStatement)ContainerUtil.find((Iterable)module.getProvides(), this::isTargetStatement);
            if (statement != null && (list = statement.getImplementationList()) != null) {
                return (PsiJavaCodeReferenceElement)ContainerUtil.find((Object[])list.getReferenceElements(), this::isTargetReference);
            }
            return null;
        }

        @Override
        @NotNull
        protected String getTargetFQN() {
            return this.myImplementerClassName;
        }

        private boolean isTargetStatement(@NotNull PsiProvidesStatement statement) {
            PsiJavaCodeReferenceElement reference = statement.getInterfaceReference();
            return reference != null && this.myInterfaceClassName.equals(reference.getQualifiedName());
        }
    }

    private static class ServiceUsesNavigationHandler
    extends ServiceNavigationHandler {
        ServiceUsesNavigationHandler(String interfaceClassName) {
            super(interfaceClassName);
        }

        @Override
        public PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule module) {
            return StreamEx.of(module.getUses().iterator()).map(PsiUsesStatement::getClassReference).findAny(this::isTargetReference).orElse(null);
        }
    }

    static abstract class ServiceNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        final String myInterfaceClassName;

        ServiceNavigationHandler(@NotNull String interfaceClassName) {
            this.myInterfaceClassName = interfaceClassName;
        }

        public void navigate(MouseEvent e, PsiElement element) {
            Optional.ofNullable(JavaModuleGraphUtil.findDescriptorByElement(element)).map(this::findTargetReference).filter(NavigationItem.class::isInstance).map(NavigationItem.class::cast).ifPresent(item -> item.navigate(true));
        }

        public abstract PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule var1);

        @NotNull
        protected String getTargetFQN() {
            return this.myInterfaceClassName;
        }

        boolean isTargetReference(PsiJavaCodeReferenceElement reference) {
            return reference != null && this.getTargetFQN().equals(reference.getQualifiedName());
        }
    }
}

